<?php
chdir('../');
require_once 'autoload.php';
$admin = new admin_controller;
$nationality = new nationality_controller;
$programmes = new programmes_controller;
$exam_types = new exam_types_controller;
$session = new session;
$exam_sessions = new exam_sessions_controller;
$exam_enrollments = new exam_enrollments_controller;
$uni = new university_controller;


$courses = new courses_controller;
$info = $uni->index();

date_default_timezone_set($info['timezone']);

$page = $utility->get_page();

require_once 'includes/session_validator.php';

if (!empty($is_authenticated) && $is_authenticated == 1) {

$docket = $exam_enrollments->show_v2($_POST['id']);

}
?>

<table class="table table-bordered table-sm">
<tr><td>Full Name</td><td><?php echo $docket['first_name'] . ' ' . $docket['last_name']; ?></td></tr>
<tr><td>Date of Birth</td><td><?php echo $docket['dob']; ?></td></tr>
<tr><td>NRC</td><td><?php echo $docket['nrc']; ?></td></tr>
<tr><td>Nationality</td><td><?php echo $docket['nationality']; ?></td></tr>
<tr><td>City/Town</td><td><?php echo $docket['city_town']; ?></td></tr>
<tr><td>Birth Place</td><td><?php echo $docket['birth_place']; ?></td></tr>
<tr><td>Telephone</td><td><?php echo $docket['telephone']; ?></td></tr>
<tr><td>WhatsApp No</td><td><?php echo $docket['whatsapp_no']; ?></td></tr>
<tr><td>Email</td><td><?php echo $docket['email_address']; ?></td></tr>
<tr><td>Programme</td><td><?php echo $programmes->show($docket['programme_id'])['name']; ?></td></tr>
<tr><td>Exam Type</td><td><?php echo $exam_types->show($docket['exam_type_id'])['name']; ?></td></tr>
<tr><td>Exam Session</td><td><?php echo $exam_sessions->show($docket['exam_session_id'])['name']; ?></td></tr>
<tr><td>Courses</td><td>
<ol>
<?php $c = unserialize($docket['courses']);

foreach (unserialize($docket['courses']) as $key => $value) {

$course = $courses->show($value);
echo "<li>".$course['code'].' '.$course['name']."</li>";
}

?>
</ol>
</td></tr>
<tr><td>Create Date</td><td><?php echo $docket['create_date']; ?></td></tr>
<tr><td>Reference No</td><td><?php echo $docket['reference_no']; ?></td></tr>
<tr><td>Payed Amount</td><td><?php echo number_format($docket['amount'], 2).' '.$info['code']; ?></td></tr>
<tr><td>Payment Date</td><td><?php echo $docket['payment_date']; ?></td></tr>
</table>

<button type="button" class="btn btn-secondary mb-3" data-bs-dismiss="modal">Close</button>
