<?php
chdir('../');
require_once 'autoload.php';
$admin = new admin_controller;
$courses = new courses_controller;
$programmes = new programmes_controller;
$session = new session;
$uni = new university_controller;
$info = $uni->index();

date_default_timezone_set($info['timezone']);

$page = $utility->get_page();

require_once 'includes/session_validator.php';

if (!empty($is_authenticated) && $is_authenticated == 1) {

$programme_list = $programmes->index();

$data = $courses->show($_POST['id']);

if (!empty($data)) {
?>

<div class="mb-2">
<label class="form-label">Programme</label>
<select required class="form-control select_edit" name="programme_id">
<option value="" selected disabled>Select Option</option>
<?php
foreach ($programme_list as $key => $value) {
?>
<option <?php echo $data['programme_id'] == $value['id'] ? ' selected ' : ''; ?> value="<?php echo $value['id']; ?>"><?php echo $value['name']; ?></option>
<?php
}
?>
</select>
</div>
<div class="mb-2">
<label class="form-label">Course Code</label>
<input type="text" value="<?php echo $data['code']; ?>" required class="form-control" name="code" placeholder="Enter course code">
</div>
<div class="mb-2">
<label class="form-label">Course Name</label>
<input type="text" value="<?php echo $data['name']; ?>" required class="form-control" name="name" placeholder="Enter course name">
</div>
<div class="mb-2">
<label class="form-label">Fee</label>
<input type="text" value="<?php echo $data['fee']; ?>" required class="form-control fee_input" name="fee" placeholder="Enter fee">
</div>
<div class="mb-3">
<label class="form-label">Status</label>
<select required class="form-control" name="status">
<option value="" selected disabled>Select Option</option>
<option value="enabled" <?php echo $data['status'] == 'enabled' ? ' selected ' : ''; ?>>ENABLED</option>
<option value="disabled" <?php echo $data['status'] == 'disabled' ? ' selected ' : ''; ?>>DISABLED</option>
</select>
</div>
<input type="hidden" name="id" value="<?php echo $_POST['id']; ?>">
<div class="mb-4">
<button type="submit" class="btn btn-primary app_btn">Save</button>
<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
</div>

<?php
}
}
?>
