<?php
chdir('../');
require_once 'autoload.php';
$admin = new admin_controller;
$session = new session;
$mail = new smtp_settings_controller;
$timezone = new timezones_controller;
$currency = new currency_controller;
$payment_gateways = new payment_gateways_controller;
$uni = new university_controller;
$info = $uni->index();

date_default_timezone_set($info['timezone']);

$page = $utility->get_page();
$smtp = $mail->index();
$timezone_list = $timezone->index();
$currency_list = $currency->index();

$gateways = $payment_gateways->index();

require_once 'includes/session_validator.php';

if (!empty($is_authenticated) && $is_authenticated == 1) {

?>
<!doctype html>
<html lang="en" class="remember-theme">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1.0">
<title>SERS - System Settings</title>
<meta name="description" content="Students Examinations Registration System">
<meta name="author" content="Bwire Mashauri">
<meta name="robots" content="index, follow">
<base href="../">
<link rel="shortcut icon" href="storage/images/misc/<?php echo $info['icon']; ?>">
<link rel="stylesheet" href="assets/js/plugins/select2/css/select2.min.css">
<link rel="stylesheet" id="css-main" href="assets/css/main.css">
<?php echo $info['theme'] !== '0' ? '<link type="text/css" rel="stylesheet" id="css-theme" href="assets/css/themes/'.$info['theme'].'.css">' : '' ; ?>
<link href="assets/js/plugins/sweetalert2/sweetalert2.min.css" rel="stylesheet" type="text/css" />
</head>
<body>
<div id="page-loader" class="show"></div>

<div id="page-container" class="sidebar-o <?php echo $info['sidebar'];?> enable-page-overlay side-scroll page-header-fixed page-footer-fixed">

<nav id="sidebar" aria-label="Main Navigation">
<div class="bg-header-dark">
<div class="content-header bg-white-5">
<a class="fw-semibold text-white tracking-wide" href="./app/dashboard">
<span class="smini-hidden desc">
Students Examinations Registration System
</span>
</a>
</div>
</div>
<div class="js-sidebar-scroll">
<div class="content-side">

<div class="text-center"><img class="mb-3 center_img" src="storage/images/misc/<?php echo $info['logo']; ?>" height="140" alt="School Logo"></div>

<ul class="nav-main">

<?php require_once 'includes/header.php'; ?>

</ul>
</div>
</div>
</nav>
<header id="page-header">
<div class="content-header">
<div class="space-x-1">
<button type="button" class="btn btn-alt-secondary" data-toggle="layout" data-action="sidebar_toggle">
<i class="fa fa-fw fa-bars"></i>
</button>
</div>
<div class="space-x-1">
<div class="dropdown d-inline-block">
<button type="button" class="btn btn-alt-secondary" id="page-header-user-dropdown" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
<i class="fa fa-fw fa-user d-sm-none"></i>
<span class="d-none d-sm-inline-block"><?php echo $profile['first_name'].' '.$profile['last_name']; ?></span>
<i class="fa fa-fw fa-angle-down opacity-50 ms-1 d-none d-sm-inline-block"></i>
</button>
<div class="dropdown-menu dropdown-menu-end p-0" aria-labelledby="page-header-user-dropdown">
<div class="bg-primary-dark rounded-top fw-semibold text-white text-center p-3">
My Profile
</div>
<div class="p-2">
<a class="dropdown-item" href="app/account">
<i class="far fa-fw fa-user me-1"></i> Account Settings
</a>
<div role="separator" class="dropdown-divider"></div>
<a class="dropdown-item" href="app/logout">
<i class="far fa-fw fa-arrow-alt-circle-left me-1"></i> Log Out
</a>
</div>
</div>
</div>
</div>
</div>
</header>
<main id="main-container">
<div class="content">

<div class="row mb-4">
<div class="col-xl-12 col-l-12 col-md-12 col-sm-12">
<div class="block block-rounded">
<div class="block-content">
<div class="block block-rounded row g-0">
<ul class="nav nav-tabs nav-tabs-block flex-md-column col-md-4 col-xxl-2" role="tablist">
<li class="nav-item d-md-flex flex-md-column" role="presentation">
<button class="nav-link text-md-start active" id="btabs-vertical-info-general-tab" data-bs-toggle="tab" data-bs-target="#btabs-vertical-info-general" role="tab" aria-controls="btabs-vertical-info-general" aria-selected="true">
<i class="fa fa-fw fa-cog opacity-50 me-1 d-none d-sm-inline-block"></i>
<span>General Settings</span>
<span class="d-none d-md-block fs-xs fw-medium opacity-75 mt-md-2">
Update system general settings like theme, university details etc.
</span>
</button>
</li>
<li class="nav-item d-md-flex flex-md-column" role="presentation">
<button class="nav-link text-md-start" id="btabs-vertical-info-image-tab" data-bs-toggle="tab" data-bs-target="#btabs-vertical-info-image" role="tab" aria-controls="btabs-vertical-info-image" aria-selected="false" tabindex="-1">
<i class="fa fa-fw fa-image opacity-50 me-1 d-none d-sm-inline-block"></i>
<span>Image Settings</span>
<span class="d-none d-md-block fs-xs fw-medium opacity-75 mt-md-2">
Update system logo and icon.
</span>
</button>
</li>
<li class="nav-item d-md-flex flex-md-column" role="presentation">
<button class="nav-link text-md-start" id="btabs-vertical-info-email-tab" data-bs-toggle="tab" data-bs-target="#btabs-vertical-info-email" role="tab" aria-controls="btabs-vertical-info-email" aria-selected="false" tabindex="-1">
<i class="fa fa-fw fa-envelope opacity-50 me-1 d-none d-sm-inline-block"></i>
<span>SMTP Settings</span>
<span class="d-none d-md-block fs-xs fw-medium opacity-75 mt-md-2">
Update your mail configuration settings for password reset.
</span>
</button>
</li>
<li class="nav-item d-md-flex flex-md-column" role="presentation">
<button class="nav-link text-md-start" id="btabs-vertical-info-payment-tab" data-bs-toggle="tab" data-bs-target="#btabs-vertical-info-payment" role="tab" aria-controls="btabs-vertical-info-payment" aria-selected="false" tabindex="-1">
<i class="fa fa-fw fa-wallet opacity-50 me-1 d-none d-sm-inline-block"></i>
<span>Payment Gateways</span>
<span class="d-none d-md-block fs-xs fw-medium opacity-75 mt-md-2">
Update your payment gateways API for examination fees.
</span>
</button>
</li>
</ul>
<div class="tab-content col-md-8 col-xxl-10">
<div class="block-content tab-pane active" id="btabs-vertical-info-general" role="tabpanel" aria-labelledby="btabs-vertical-info-general-tab" tabindex="0">
<h4 class="fw-semibold">General Settings</h4>
<form autocomplete="off" class="app_frm" action="app/routes/update_general_settings" method="POST" enctype="multipart/form-data">
<div class="mb-2">
<label class="form-label">University Name</label>
<input type="text" value="<?php echo $info['name']; ?>" required class="form-control" name="name" placeholder="Enter university name">
</div>

<div class="row mb-2">
<div class="col-6">
<label class="form-label">Phone 1</label>
<input type="text" value="<?php echo $info['phone_1']; ?>" required class="form-control" name="phone_1" placeholder="Enter phone 1">
</div>
<div class="col-6">
<label class="form-label">Phone 2 (optional)</label>
<input type="text" value="<?php echo $info['phone_2']; ?>" class="form-control" name="phone_2" placeholder="Enter phone 2 (optional)">
</div>
</div>

<div class="row mb-2">
<div class="col-6">
<label class="form-label">Email 1</label>
<input type="email" value="<?php echo $info['email_1']; ?>" required class="form-control" name="email_1" placeholder="Enter email 1">
</div>
<div class="col-6">
<label class="form-label">Email 2 (optional)</label>
<input type="email" value="<?php echo $info['email_2']; ?>" class="form-control" name="email_2" placeholder="Enter email 2 (optional)">
</div>
</div>

<div class="mb-2">
<label class="form-label">University Address</label>
<input type="text" value="<?php echo $info['address']; ?>" required class="form-control" name="address" placeholder="Enter university address">
</div>
<div class="mb-2">
<label class="form-label">University Slogan</label>
<input type="text" value="<?php echo $info['slogan']; ?>" required class="form-control" name="slogan" placeholder="Enter university slogan">
</div>

<div class="row mb-2">
<div class="col-6">
<label class="form-label">University Timezone</label>
<select required class="form-control select_2" name="timezone">
<option disabled selected>Select Option</option>
<?php
foreach ($timezone_list as $key => $value) {
?><option <?php echo $info['timezone'] == $value['timezone'] ? ' selected ' : ''; ?> value="<?php echo $value['timezone']; ?>"><?php echo $value['timezone']; ?></option><?php
}
?>
</select>
</div>
<div class="col-6">
<label class="form-label">University Currency</label>
<select required class="form-control select_2" name="currency">
<option disabled selected>Select Option</option>
<?php
foreach ($currency_list as $key => $value) {
?><option <?php echo $info['currency'] == $value['id'] ? ' selected ' : ''; ?> value="<?php echo $value['id']; ?>"><?php echo $value['currency_name']; ?></option><?php
}
?>
</select>
</div>
</div>

<div class="row mb-2">
<div class="col-6">
<label class="form-label">Signature Name</label>
<input type="text" value="<?php echo $info['sig_name']; ?>" required class="form-control" name="sig_name" placeholder="Enter signature name">
</div>
<div class="col-6">
<label class="form-label">Signature Title</label>
<input type="text" value="<?php echo $info['sig_title']; ?>" required class="form-control" name="sig_title" placeholder="Enter signature title">
</div>
</div>

<div class="row mb-2">
<div class="col-12">
<label class="form-label">Signature (leave blank if no update)</label>
<input type="file" class="form-control" name="file">
</div>
</div>

<div class="row mb-3">
<div class="col-6">
<label class="form-label">Theme Color</label>
<select required class="form-control" name="theme">
<option disabled selected>Select Option</option>
<option <?php echo $info['theme'] == '0' ? ' selected ' : ''; ?> value="0">Default Theme Color</option>
<option <?php echo $info['theme'] == '1' ? ' selected ' : ''; ?> value="1">Theme Color 1</option>
<option <?php echo $info['theme'] == '2' ? ' selected ' : ''; ?> value="2">Theme Color 2</option>
<option <?php echo $info['theme'] == '3' ? ' selected ' : ''; ?> value="3">Theme Color 3</option>
<option <?php echo $info['theme'] == '4' ? ' selected ' : ''; ?> value="4">Theme Color 4</option>
<option <?php echo $info['theme'] == '5' ? ' selected ' : ''; ?> value="5">Theme Color 5</option>
<option <?php echo $info['theme'] == '6' ? ' selected ' : ''; ?> value="6">Theme Color 6</option>
<option <?php echo $info['theme'] == '7' ? ' selected ' : ''; ?> value="7">Theme Color 7</option>
<option <?php echo $info['theme'] == '8' ? ' selected ' : ''; ?> value="8">Theme Color 8</option>
</select>
</div>
<div class="col-6">
<label class="form-label">SideBar</label>
<select required class="form-control" name="sidebar">
<option disabled selected>Select Option</option>
<option <?php echo $info['sidebar'] == 'sidebar-dark' ? ' selected ' : ''; ?> value="sidebar-dark">Dark</option>
<option <?php echo $info['sidebar'] == 'sidebar-light' ? ' selected ' : ''; ?> value="sidebar-light">Light</option>
</select>
</div>
</div>
<input type="hidden" name="old_file" value="<?php echo $info['sig_file']; ?>">
<?= $waf->csrf_field('update_general_settings.php', 600) ?>
<div class="mb-3">
<button type="submit" class="btn btn-primary app_btn">Save</button>
</div>
</form>

</div>
<div class="block-content tab-pane" id="btabs-vertical-info-image" role="tabpanel" aria-labelledby="btabs-vertical-info-image-tab" tabindex="0">
<h4 class="fw-semibold">Image Settings</h4>
<form autocomplete="off" enctype="multipart/form-data" class="app_frm" action="app/routes/update_image" method="POST">
<div class="mb-2">
<label class="form-label">File</label>
<input type="file"  required class="form-control" name="file" accept=".png,.jpeg,.jpg">
</div>
<div class="mb-3">
<label class="form-label">Asset</label>
<select required class="form-control" name="asset">
<option value="" selected disabled>Select Asset</option>
<option value="logo">LOGO</option>
<option value="icon">ICON</option>
</select>
</div>
<?= $waf->csrf_field('update_image.php', 600) ?>
<div class="mb-2">
<button type="submit" class="btn btn-primary app_btn">Save</button>
</div>
</form>
</div>
<div class="block-content tab-pane" id="btabs-vertical-info-email" role="tabpanel" aria-labelledby="btabs-vertical-info-email-tab" tabindex="0">
<h4 class="fw-semibold">SMTP Settings</h4>
<form autocomplete="off" class="app_frm" action="app/routes/update_email" method="POST">
<div class="mb-2">
<label class="form-label">Server</label>
<input type="text" value="<?php echo $smtp['server']; ?>" required class="form-control" name="server" placeholder="Enter server address">
</div>
<div class="mb-2">
<label class="form-label">Username</label>
<input type="text" value="<?php echo $smtp['username']; ?>" required class="form-control" name="username" placeholder="Enter server username">
</div>
<div class="mb-2">
<label class="form-label">Password</label>
<input type="text" value="<?php echo $smtp['password']; ?>" required class="form-control" name="password" placeholder="Enter server password">
</div>
<div class="mb-2">
<label class="form-label">Port</label>
<input type="text" value="<?php echo $smtp['port']; ?>" required class="form-control" name="port" placeholder="Enter server port"  onkeypress='return event.charCode >= 48 && event.charCode <= 57'>
</div>
<div class="mb-3">
<label class="form-label">Encryption</label>
<select required class="form-control" name="encryption">
<option <?php echo $smtp['encryption'] == 'tls' ? ' selected ' : ''; ?> value="tls">TLS</option>
<option <?php echo $smtp['encryption'] == 'ssl' ? ' selected ' : ''; ?> value="ssl">SSL</option>
</select>
</div>
<?= $waf->csrf_field('update_email.php', 600) ?>
<div class="mb-2">
<button type="submit" class="btn btn-primary app_btn">Save</button>
</div>
</form>
</div>
<div class="block-content tab-pane" id="btabs-vertical-info-payment" role="tabpanel" aria-labelledby="btabs-vertical-info-payment-tab" tabindex="0">
<h4 class="fw-semibold">Payment Gateways</h4>
<?php
foreach ($gateways as $key => $value) {

$details = unserialize($value['details']);

switch ($value['name']) {
case 'LENCO':
?>
<form autocomplete="off" class="app_frm" action="app/routes/update_gateway" method="POST">
<div class="mb-2">
<label class="form-label">Lenco Secret Key</label>
<input type="text" value="<?php echo $details['secret_key']; ?>" required class="form-control" name="secret_key">
</div>
<div class="mb-3">
<label class="form-label">Lenco Public Key</label>
<input type="text" value="<?php echo $details['public_key']; ?>" required class="form-control" name="public_key">
</div>
<?= $waf->csrf_field('update_gateway.php', 600) ?>
<input type="hidden" value="lenco" name='gateway_type'>
<input type="hidden" name="id" value='<?php echo $value['id']; ?>'>
<div class="mb-2">
<button type="submit" class="btn btn-primary app_btn">Save</button>
</div>
</form>
<?php
break;
}

}

?>
</div>
</div>
</div>
</div>
</div>
</div>
</div>

</div>
</main>
<footer id="page-footer" class="bg-body-light">
<div class="content py-0">
<div class="row fs-sm">
<div class="col-sm-6 order-sm-2 mb-1 mb-sm-0 text-center text-sm-end">
<?php echo $info['name']; ?>
</div>
<div class="col-sm-6 order-sm-1 text-center text-sm-start">
<a class="fw-semibold">Students Examinations Registration System</a> &copy; <span data-toggle="year-copy"></span>
</div>
</div>
</div>
</footer>
</div>
<script src="assets/js/main.js"></script>
<script src="assets/js/lib/jquery.min.js"></script>
<script src="assets/js/forms.js"></script>
<script src="assets/js/plugins/sweetalert2/sweetalert2.min.js"></script>
<script src="assets/js/plugins/select2/js/select2.full.min.js"></script>
<script nonce="<?php echo $wafConfig['nonce']; ?>">
$(".select_2").select2();
</script>
<?php require_once('includes/check_reply.php'); ?>
</body>
</html>
<?php

}else{

header("location:../");

}
?>
