<?php
require_once('../assets/constants/config.php');
require_once('constants/check-login.php');

try {
$conn = new PDO("mysql:host=$servername;dbname=$dbname;charset=utf8mb4;collation=utf8_general_ci;prefix=''", $username, $password);
$conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);


$stmt = $conn->prepare("SELECT * FROM tbl_school_info");
$stmt->execute();
$result = $stmt->fetchAll();

foreach($result as $row) {

$school_name = $row[0];
$phone = $row[1];
$email = $row[2];
$address = $row[3];
$logo = $row[4];
$timez = $row[5];
$crr = $row[6];
}

}catch(PDOException $e)
{
echo "Connection failed: " . $e->getMessage();
}


?>
<!DOCTYPE html>
<html lang="en">

<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<meta http-equiv="X-UA-Compatible" content="ie=edge">
<title>OES - School Info</title>
<link rel="icon" href="../assets/images/favicon.ico">
<link href="../assets/google-fonts/nunito.css" rel="stylesheet">
<link type="text/css" rel="stylesheet" href="../assets/loader/waitMe.css"><link rel="stylesheet" href="../assets/styles/css/themes/lite-purple.min.css">
<link rel="stylesheet" href="../assets/styles/vendor/perfect-scrollbar.css">
<link rel="stylesheet" href="../assets/styles/vendor/datatables.min.css">
<link href="../assets/plugins/toastr/toastr.min.css" rel="stylesheet" type="text/css"/>


</head>

<style>
.school-logo {
height:100px;
width:100px;
object-fit:cover;
}

</style>

<body>
<div class="app-admin-wrap">
<div class="main-header">
<div class="logo">
<img src="../assets/images/logo.png" alt="">
</div>

<div class="menu-toggle">
<div></div>
<div></div>
<div></div>
</div>

<div class="d-flex align-items-center">
<div class="search-bar">
<input type="text" placeholder="Search students..">
<i class="search-icon text-muted i-Magnifi-Glass1"></i>
</div>
</div>

<div style="margin: auto"></div>

<div class="header-part-right">

<i class="i-Full-Screen header-icon d-none d-sm-inline-block" data-fullscreen></i>


<div class="dropdown">
<div class="user colalign-self-end">
<?php
if ($myvataor == null) {

print ' <img class="img-crop" src="../assets/images/blank_avatar.png" id="userDropdown" alt="" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">';

}else{

print ' <img class="img-crop" src="../assets/uploads/avatar/'.$myvataor.'" id="userDropdown" alt="" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">';

}

?>


<div class="dropdown-menu dropdown-menu-right" aria-labelledby="userDropdown">
<div class="dropdown-header">
<i class="i-Lock-User mr-1"></i> <?php echo $myemail; ?>
</div>
<a class="dropdown-item" href="account">Account settings</a>
<a class="dropdown-item" href="../logout">Sign out</a>
</div>
</div>
</div>
</div>

</div>

<div class="side-content-wrap">
<div class="sidebar-left open" data-perfect-scrollbar data-suppress-scroll-x="true">
<ul class="navigation-left">
<li class="nav-item" >
<a class="nav-item-hold" href="./">
<i class="nav-icon i-Bar-Chart"></i>
<span class="nav-text">Dashboard</span>
</a>
<div class="triangle"></div>
</li>
<li class="nav-item">
<a class="nav-item-hold" href="departments">
<i class="nav-icon i-File"></i>
<span class="nav-text">Departments</span>
</a>
<div class="triangle"></div>
</li>
<li class="nav-item">
<a class="nav-item-hold" href="classes">
<i class="nav-icon i-Folder-Open"></i>
<span class="nav-text">Classes</span>
</a>
<div class="triangle"></div>
</li>
<li class="nav-item">
<a class="nav-item-hold" href="subjects">
<i class="nav-icon i-Library"></i>
<span class="nav-text">Subjects</span>
</a>
<div class="triangle"></div>
</li>
<li class="nav-item">
<a class="nav-item-hold" href="students">
<i class="nav-icon i-Administrator"></i>
<span class="nav-text">Students</span>
</a>
<div class="triangle"></div>
</li>
<li class="nav-item">
<a class="nav-item-hold" href="exams">
<i class="nav-icon i-File-Horizontal-Text"></i>
<span class="nav-text">Examinations</span>
</a>
<div class="triangle"></div>
</li>
<li class="nav-item">
<a class="nav-item-hold" href="notice">
<i class="nav-icon i-Bell"></i>
<span class="nav-text">Notice</span>
</a>
<div class="triangle"></div>
</li>
<li class="nav-item">
<a class="nav-item-hold" href="enroll_numbers">
<i class="nav-icon i-File-Clipboard-File--Text"></i>
<span class="nav-text">Enroll Numbers</span>
</a>
<div class="triangle"></div>
</li>
<li class="nav-item  active">
<a class="nav-item-hold" href="school">
<i class="nav-icon i-Big-Data"></i>
<span class="nav-text">School Info</span>
</a>
<div class="triangle"></div>
</li>

<li class="nav-item">
<a class="nav-item-hold" href="smtp">
<i class="nav-icon i-Email"></i>
<span class="nav-text">SMTP</span>
</a>
<div class="triangle"></div>
</li>

</ul>
</div>


<div class="sidebar-overlay"></div>
</div>


<div class="main-content-wrap sidenav-open d-flex flex-column">
<div class="breadcrumb">
<h1>School Information</h1>

</div>
<div class="separator-breadcrumb border-top"></div>
<div class="row mb-4">
<div class="col-md-12 mb-4">


<div class="mr-3 ml-3">

</div>
<div class="tab-content" id="myPillTabContent">
<div class="tab-pane fade active show" id="addPIll" role="tabpanel" aria-labelledby="home-icon-pill">
<div class="card mb-5">
<div class="card-body">

<form class="app_form"  action="app/update-school.php" method="POST" autocomplete="OFF" enctype="multipart/form-data" >
<div class="form-group row">
<label for="inputEmail3" class="col-sm-2 col-form-label">School Name</label>
<div class="col-sm-10">
<input type="text" value="<?php echo $school_name; ?>" required name="name" class="txt-tit form-control" id="inputEmail3" placeholder="Enter school name">
</div>
</div>

<div class="form-group row">
<label for="inputEmail3" class="col-sm-2 col-form-label">School Phone</label>
<div class="col-sm-10">
<input type="text" value="<?php echo $phone; ?>" required name="phone" class="form-control" id="inputEmail3" placeholder="Enter school phone">
</div>
</div>

<div class="form-group row">
<label for="inputEmail3" class="col-sm-2 col-form-label">School Email</label>
<div class="col-sm-10">
<input type="email" value="<?php echo $email; ?>" required name="email" class="form-control" id="inputEmail3" placeholder="Enter school email">
</div>
</div>
<div class="form-group row">
<label for="inputEmail3" class="col-sm-2 col-form-label">School Address</label>
<div class="col-sm-10">
<input type="text" value="<?php echo $address; ?>" required name="address" class="txt-tit form-control" id="inputEmail3" placeholder="Enter school address">
</div>
</div>

<div class="form-group row">
<label for="inputEmail3" class="col-sm-2 col-form-label">Currency</label>
<div class="col-sm-10">
<input type="text" value="<?php echo $crr; ?>" required name="currency" class="txt-cap form-control" id="inputEmail3" placeholder="Enter currency">
</div>
</div>

<div class="form-group row">
<label for="inputEmail3" class="col-sm-2 col-form-label">Timezone</label>
<div class="col-sm-10">
<select required name="timezone" class="js-example-basic-single form-control" >
<option value=""selected disabled>Select timezone</option>
<?php
try {
$connb = new PDO("mysql:host=$servername;dbname=$dbname", $username, $password);
$connb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);


$stmtb = $connb->prepare("SELECT * FROM tbl_timezones ORDER BY timezone");
$stmtb->execute();
$resultb = $stmtb->fetchAll();

foreach($resultb as $rowb)
{
print '<option'; if ($rowb[2] == $timez) { print ' selected ';} print ' value="'.$rowb[2].'">'.$rowb[2].'</option>';

}

}catch(PDOException $e)
{
echo "Connection failed: " . $e->getMessage();
}
?>
</select>
</div>
</div>

<div class="form-group row">
<label for="inputEmail3" class="col-sm-2 col-form-label">School Logo (400 <small>X</small> 400)</label>
<div class="col-sm-10">
<img id="blah" class="school-logo" src="../assets/uploads/logo/<?php echo $logo; ?>"><br><br>
<input type="file"  onchange="readURL(this);"  name="image" accept="image/*" id="inputEmail3" >
<script>
function readURL(input) {
if (input.files && input.files[0]) {
var reader = new FileReader();

reader.onload = function (e) {
$('#blah')
.attr('src', e.target.result);
};

reader.readAsDataURL(input.files[0]);
}
}
</script>

</div>
</div>

<input type="hidden" name="schoollogo" value="<?php echo $logo; ?>">



<div class="form-group row">
<label for="inputEmail3" class="col-sm-2 col-form-label"></label>
<div class="col-sm-10">
<button type="submit"   class="btn btn-primary app_btn ">Save Changes</button>
</div>
</div>
</form></div>

</div>
</div>


</div>

</div>


</div>

<div class="flex-grow-1"></div>


</div>

</div>
<div class="search-ui">
<div class="search-header">
<img src="assets/images/logo.png" alt="" class="logo">
<button class="search-close btn btn-icon bg-transparent float-right mt-2">
<i class="i-Close-Window text-22 text-muted"></i>
</button>
</div>
<form class="app_form"  action="search" method="GET" autocomplete="OFF">
<input type="text" name="keyword" required  placeholder="first name OR last name" class="search-input" autofocus>
</form>

</div>

<script src="../assets/js/vendor/jquery-3.3.1.min.js"></script>
<script src="../assets/js/vendor/bootstrap.bundle.min.js"></script>
<script src="../assets/js/vendor/perfect-scrollbar.min.js"></script>

<script src="../assets/js/vendor/datatables.min.js"></script>
<script src="../assets/loader/waitMe.js"></script><script src="../assets/js/es5/script.min.js"></script>
<script src="../assets/js/datatables.script.js"></script>
<script src="../assets/plugins/toastr/toastr.min.js"></script>
<?php require_once('../assets/constants/check-reply.php') ;?>

</body>


</html>
