<?php
class dashboard_model {
    private $db;
    public function __construct() {
        $this->db = database::connect();
    }

    public function programmes() {
        return $this->db->query("SELECT COUNT(id) as total_programmes FROM programmes")->fetchAll(PDO::FETCH_ASSOC);
    }

    public function courses() {
        return $this->db->query("SELECT COUNT(id) as total_courses FROM courses")->fetchAll(PDO::FETCH_ASSOC);
    }

    public function sessions() {
        return $this->db->query("SELECT COUNT(id) as total_sessions FROM exam_sessions")->fetchAll(PDO::FETCH_ASSOC);
    }

    public function types() {
        return $this->db->query("SELECT COUNT(id) as total_types FROM exam_types")->fetchAll(PDO::FETCH_ASSOC);
    }

    public function payments() {
        return $this->db->query("SELECT
    SUM(CASE WHEN DATE(payment_date) = CURDATE() THEN amount ELSE 0 END) AS total_today,
    SUM(CASE WHEN YEARWEEK(payment_date, 1) = YEARWEEK(CURDATE(), 1) THEN amount ELSE 0 END) AS total_this_week,
    SUM(CASE WHEN YEAR(payment_date) = YEAR(CURDATE())
              AND MONTH(payment_date) = MONTH(CURDATE())
        THEN amount ELSE 0 END) AS total_this_month,

    SUM(amount) AS total_all_time

FROM payments")->fetchAll(PDO::FETCH_ASSOC);
    }


}
?>
