<?php
require_once 'autoload.php';
error_reporting(0);

$uni = new university_controller;
$nationality = new nationality_controller;
$programmes = new programmes_controller;
$exam_types = new exam_types_controller;
$exam_sessions = new exam_sessions_controller;
$exam_enrollments = new exam_enrollments_controller;
$courses = new courses_controller;

$info = $uni->index();

if (!empty($_GET['ref']) && !empty($docket = $exam_enrollments->show($_GET['ref']))) {

require_once('tcpdf/tcpdf.php');

if ((isset($_SERVER['HTTPS']) &&   (($_SERVER['HTTPS'] == 'on'))) || (isset($_SERVER['HTTPS']) && $_SERVER['SERVER_PORT'] == 443))
{
$actual_link = 'https://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'];
}
else
{
$actual_link = 'http://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'];
}
$actual_link = str_replace("docket.php","docket?ref=".$_GET['ref'],$actual_link);

$student_name = $docket['first_name'].' '.$docket['last_name'];
$student_number = $docket['student_number'];
$student_id   = $docket['nrc'];
$program      = $programmes->show($docket['programme_id'])['name'];
$exam_session = $exam_sessions->show($docket['exam_session_id'])['name'];
$exam_type = $exam_types->show($docket['exam_type_id'])['name'];


$subjects = array();
foreach (unserialize($docket['courses']) as $value) {
    $course = $courses->show($value);
    array_push($subjects, [$course['code'], $course['name']]);
}

$university_name = $info['name'];
$university_address = $info['address'];
$university_phone1 = $info['phone_1'];
$university_phone2 = $info['phone_2'];
$university_email1 = $info['email_1'];
$university_email2 = $info['email_2'];

$pdf = new TCPDF('P', 'mm', 'A4', true, 'UTF-8', false);
$pdf->SetCreator('Exam Office');
$pdf->SetAuthor('Exam Office');
$pdf->SetTitle('Exam Docket - ' . $student_name);
$pdf->SetSubject('Exam Docket');

$pdf->setPrintHeader(false);
$pdf->setPrintFooter(false);
$pdf->SetMargins(15, 15, 15);
$pdf->SetAutoPageBreak(true, 15);
$pdf->AddPage();
$pdf->SetFont('helvetica','',12);


$side_file = __DIR__.'/storage/images/students/'.$_GET['ref'].'.png';
$side_html = file_exists($side_file) ? '<img src="'.$side_file.'" width="80">' : '';

$logo_file = __DIR__ . '/storage/images/misc/' . $info['logo'];
$logo_html = file_exists($logo_file) ? '<img src="' . $logo_file . '" width="80">' : '';

$sig_file = __DIR__ . '/storage/images/misc/' . $info['sig_file'];
$sig_html = file_exists($sig_file) ? '<img src="' . $sig_file . '" width="100">' : '';

$html = <<<HTML
<style>
body { font-family: helvetica, sans-serif; font-size:12pt; }
.header-table { width:100%; border:none; }
.header-table td { vertical-align: middle; text-align:center; }
.center-title { font-size:14pt; font-weight:bold; }
.center-subtitle { font-size:13pt; }
.university-info { font-size:10pt; line-height:1.3; text-align:center; }
.info { margin-top:10px; line-height:1.5; }
.table { width:100%; border-collapse: collapse; margin-top:15px; }
.table th, .table td { border:1px solid #000; padding:5px; text-align:left; }
.table th { background-color:#ddd; }
.footer { margin-top:20px; text-align:center; font-style:italic; font-size:10pt; }
</style>

<table class="header-table">
<tr>
    <td style="width:15%; text-align:left;">{$side_html}</td>
    <td style="width:70%; text-align:center;">
        {$logo_html}<br>
        <div class="center-title">{$university_name}</div>
        <div class="center-subtitle">EXAMINATION DOCKET</div>
        <div class="university-info">
            {$university_address}<br>
            Phone: {$university_phone1} | {$university_phone2}<br>
            Email: {$university_email1} | {$university_email2}
        </div>
    </td>
    <td style="width:15%; text-align:right;">&nbsp;</td>
</tr>
</table>

<div class="info">
<p><strong>Student Name:</strong> {$student_name}<br>
<strong>Student Number:</strong> {$student_number}<br>
<strong>NRC:</strong> {$student_id}<br>
<strong>Programme:</strong> {$program}<br>
<strong>Exam Type:</strong> {$exam_type}<br>
<strong>Exam Session:</strong> {$exam_session}</p>
</div>

<table class="table">
<tr style="background-color:lightgray;">
<th width="25%">Course Code</th>
<th width="75%">Course Name</th>
</tr>
HTML;

foreach($subjects as $s){
    $html .= "<tr><td>{$s[0]}</td><td>{$s[1]}</td></tr>";
}

$html .= <<<HTML
</table><br><br>

<div class="footer">
Please keep this docket safe. Present it before entering the examination room.
</div>
HTML;


$pdf->writeHTML($html, true, false, true, false, '');


$html = '<br><br><table  width="100%" align="center">
<tr>
<td>'.$sig_html.'</td>
</tr>
<tr>
<td>'.$info['sig_name'].'</td>
</tr>
<tr>
<td><b>'.$info['sig_title'].'</b></td>
</tr>
</table>';

$pdf->writeHTML($html, true, false, true, false, '');

$style = [
    'border' => 0,
    'vpadding' => 'auto',
    'hpadding' => 'auto',
    'fgcolor' => [0,0,0],
    'bgcolor' => false
];
$pdf->write2DBarcode(
    $actual_link,
    'QRCODE,H',
    160, 10, 40, 40,
    $style,
    'N'
);

$pdf->Output('exam_docket.pdf','I');

}else{

header("location:../");

}

?>
