<!DOCTYPE html>
<html lang="en">
<?php
require_once('../assets/constants/config.php');
require_once('constants/check-login.php');

if (!isset($_GET['node'])) {
header("location:./");
}

try {
$conn = new PDO("mysql:host=$servername;dbname=$dbname", $username, $password);
$conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);


$stmt = $conn->prepare("SELECT * FROM tbl_exams WHERE exam_id = ?");
$stmt->execute([$_GET['node']]);
$result = $stmt->fetchAll();
if (count($result)  < 1) {
header("location:./");
}

foreach($result as $row)
{
$exam_name = $row[1];
$passmark = $row[3];
}
}catch(PDOException $e)
{
echo "Connection failed: " . $e->getMessage();
}
?>
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<meta http-equiv="X-UA-Compatible" content="ie=edge">
<title>OES - Corrections</title>
<link rel="icon" href="../assets/images/favicon.ico">
<link href="../assets/google-fonts/nunito.css" rel="stylesheet">
<link type="text/css" rel="stylesheet" href="../assets/loader/waitMe.css"><link rel="stylesheet" href="../assets/styles/css/themes/lite-purple.min.css">
<link rel="stylesheet" href="../assets/styles/vendor/perfect-scrollbar.css">
<link rel="stylesheet" href="../assets/styles/vendor/datatables.min.css">
<link rel="stylesheet" href="../assets/styles/vendor/pickadate/classic.css">
<link rel="stylesheet" href="../assets/styles/vendor/pickadate/classic.date.css">

<link href="../assets/plugins/toastr/toastr.min.css" rel="stylesheet" type="text/css"/>
<script src="../assets/plugins/summernote/jquery-3.4.1.slim.min.js" integrity="sha384-J6qa4849blE2+poT4WnyKhv5vZF5SrPo0iEjwBvKU7imGFAV0wwj1yYfoRSJoZ+n" crossorigin="anonymous"></script>
<link href="../assets/plugins/summernote/summernote-lite.min.css" rel="stylesheet">
<script src="../assets/plugins/summernote/summernote-lite.min.js"></script>
<script src="../assets/plugins/summernote/summernote-fontawesome.js"></script>
<link rel="stylesheet" href="../assets/styles/css/themes/icons.css">

</head>

<body>
<div class="app-admin-wrap">
<div class="main-header">
<div class="logo">
<img src="../assets/images/logo.png" alt="">
</div>

<div class="menu-toggle">
<div></div>
<div></div>
<div></div>
</div>


<div style="margin: auto"></div>

<div class="header-part-right">

<i class="i-Full-Screen header-icon d-none d-sm-inline-block" data-fullscreen></i>


<div class="dropdown">
<div class="user colalign-self-end">
<?php
if ($myvataor == null) {

print ' <img class="img-crop" src="../assets/images/blank_avatar.png" id="userDropdown" alt="" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">';

}else{

print ' <img class="img-crop" src="../assets/uploads/avatar/'.$myvataor.'" id="userDropdown" alt="" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">';

}

?>


<div class="dropdown-menu dropdown-menu-right" aria-labelledby="userDropdown">
<div class="dropdown-header">
<i class="i-Lock-User mr-1"></i> <?php echo $myemail; ?>
</div>
<a class="dropdown-item" href="account">Account settings</a>
<a class="dropdown-item" href="../logout">Sign out</a>
</div>
</div>
</div>
</div>

</div>


<div class="side-content-wrap">
<div class="sidebar-left open" data-perfect-scrollbar data-suppress-scroll-x="true">
<ul class="navigation-left">
<li class="nav-item" >
<a class="nav-item-hold" href="./">
<i class="nav-icon i-Bar-Chart"></i>
<span class="nav-text">Dashboard</span>
</a>
<div class="triangle"></div>
</li>
<li class="nav-item">
<a class="nav-item-hold" href="subjects">
<i class="nav-icon i-Library"></i>
<span class="nav-text">Subjects</span>
</a>
<div class="triangle"></div>
</li>
<li class="nav-item">
<a class="nav-item-hold" href="students">
<i class="nav-icon i-Administrator"></i>
<span class="nav-text">Students</span>
</a>
<div class="triangle"></div>
</li>
<li class="nav-item">
<a class="nav-item-hold" href="exams">
<i class="nav-icon i-File-Horizontal-Text"></i>
<span class="nav-text">Examinations</span>
</a>
<div class="triangle"></div>
</li>
<li class="nav-item">
<a class="nav-item-hold" href="notice">
<i class="nav-icon i-Bell"></i>
<span class="nav-text">Notice</span>
</a>
<div class="triangle"></div>
</li>

<li class="nav-item">
<a class="nav-item-hold" href="assessments">
<i class="nav-icon i-Data"></i>
<span class="nav-text">Assessment Records</span>
</a>
<div class="triangle"></div>
</li>

</ul>
</div>


<div class="sidebar-overlay"></div>
</div>


<div class="main-content-wrap sidenav-open d-flex flex-column">
<div class="breadcrumb">
<h1>Exam Corrections</h1>
</div>

<div class="separator-breadcrumb border-top"></div>
<div class="row">
<div class="col-md-12">
<div class="card mb-3">
<div class="card-body">
<?php

try {
$conn = new PDO("mysql:host=$servername;dbname=$dbname", $username, $password);
$conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

$stmt = $conn->prepare("SELECT * FROM tbl_asessment_records WHERE student = :me AND exam = :exam AND submission = '1'");
$stmt->bindParam(':me', $_SESSION['id']);
$stmt->bindParam(':exam', $_GET['node']);
$stmt->execute();
$result = $stmt->fetchAll();

if (count($result) < 1) {
header("location:./");
}

foreach ($result as $row) {

$questions = explode(",",$row[6]);
$answers = explode(",",$row[7]);
$marking_scheme = explode(",",$row[8]);
$score = $row[5];

}

foreach($questions as $key => $question) {
$answ = $marking_scheme[$key];

$st_answ = $answers[$key];

$stmt = $conn->prepare("SELECT * FROM tbl_questions WHERE id = :ques ORDER BY rand()");
$stmt->bindParam(':ques', $question);
$stmt->execute();
$result = $stmt->fetchAll();

foreach($result as $row)
{

$qs = $row['question'];
$type = $row['type'];
$op1 = $row['op1'];
$op2 = $row['op2'];
$op3 = $row['op3'];
$op4 = $row['op4'];
$answer = $row['answer'];

?>

<div class="">
<?php echo $qs;?>
<?php
if ($type == "1") {

?>

<label>
<span <?php if ($answ == "op1") { print 'style="color:green; font-weight:bold"';} ?>>A) <?php echo $op1; ?></span>
<span class="checkmark"></span>
</label><br>

<label>
<span <?php if ($answ == "op2") { print 'style="color:green; font-weight:bold"';} ?>>B) <?php echo $op2; ?></span>
<span class="checkmark"></span>
</label><br>

<label>
<span <?php if ($answ == "op3") { print 'style="color:green; font-weight:bold"';} ?>>C) <?php echo $op3; ?></span>
<span class="checkmark"></span>
</label><br>

<label>

<span <?php if ($answ == "op4") { print 'style="color:green; font-weight:bold"';} ?>>D) <?php echo $op4; ?></span>
<span class="checkmark"></span>
</label><br>
<b>Your Answer : <?php
if ($st_answ == "N/A") {
print '';
}else{
print $row[''.$st_answ.''];
}
?>
</b>
<?php


}

if ($type == "2") {

?>
<div class="form-group">
<input disabled autocomplete="OFF" type="text" class="form-control" value="<?php echo $answer; ?>">
</div>
<b>Your Answer : <?php
if ($st_answ == "N/A") {
print '';
}else{
print $st_answ;
}
?>
</b>

<?php

}

?>

</div><hr>

<?php
}


}

}catch(PDOException $e)
{
echo "Connection failed: " . $e->getMessage();
}


?>
</div>
</div>
</div>

</div><div class="row">
<div class="col-sm-12">
<div class="card text-left">

<div class="card-body">
<h4 class="card-title mb-3">Results Summary</h4>
<p>Exam Name : <?php echo $exam_name; ?><br> Passmark : <?php echo $passmark; ?>% <br> Score : <?php echo $score; ?>%<br>Status : <?php if ($score >= $passmark) { print 'PASS'; } else { print 'FAIL';}?></p>
<div class="progress mb-3">
<div class="progress-bar progress-bar-striped progress-bar-animated <?php if ($score >= $passmark) { print 'bg-success'; } else { print 'bg-danger';}?>" role="progressbar" style="width: <?php echo $score; ?>%" aria-valuenow="<?php echo $score; ?>" aria-valuemin="0" aria-valuemax="100"><?php echo $score; ?>%</div>
</div>


</div>
</div>
</div></div>





<div class="flex-grow-1"></div>

</div>

</div>

<script src="../assets/js/vendor/jquery-3.3.1.min.js"></script>
<script src="../assets/js/vendor/bootstrap.bundle.min.js"></script>
<script src="../assets/js/vendor/perfect-scrollbar.min.js"></script>

<script src="../assets/js/vendor/pickadate/picker.js"></script>
<script src="../assets/js/vendor/pickadate/picker.date.js"></script>

<script src="../assets/js/vendor/datatables.min.js"></script>
<script src="../assets/loader/waitMe.js"></script><script src="../assets/js/es5/script.min.js"></script>
<script src="../assets/js/datatables.script.js"></script>
<script src="../assets/js/form.basic.script.js"></script>

<script>
$("[data-toggle=popover]").popover();
</script>

<script src="../assets/plugins/toastr/toastr.min.js"></script>
<?php require_once('../assets/constants/check-reply.php') ;?>

</body>

</html>
