<?php
chdir('../');
require_once 'autoload.php';
$admin = new admin_controller;
$session = new session;
$uni = new university_controller;
$info = $uni->index();

date_default_timezone_set($info['timezone']);

$page = $utility->get_page();

require_once 'includes/session_validator.php';

if (!empty($is_authenticated) && $is_authenticated == 1) {

?>
<!doctype html>
<html lang="en" class="remember-theme">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1.0">
<title>SERS - Account Settings</title>
<meta name="description" content="Students Examinations Registration System">
<meta name="author" content="Bwire Mashauri">
<meta name="robots" content="index, follow">
<base href="../">
<link rel="shortcut icon" href="storage/images/misc/<?php echo $info['icon']; ?>">
<link rel="stylesheet" id="css-main" href="assets/css/main.css">
<?php echo $info['theme'] !== '0' ? '<link type="text/css" rel="stylesheet" id="css-theme" href="assets/css/themes/'.$info['theme'].'.css">' : '' ; ?>
<link href="assets/js/plugins/sweetalert2/sweetalert2.min.css" rel="stylesheet" type="text/css" />
</head>
<body>
<div id="page-loader" class="show"></div>

<div id="page-container" class="sidebar-o <?php echo $info['sidebar'];?> enable-page-overlay side-scroll page-header-fixed page-footer-fixed">

<nav id="sidebar" aria-label="Main Navigation">
<div class="bg-header-dark">
<div class="content-header bg-white-5">
<a class="fw-semibold text-white tracking-wide" href="./app/dashboard">
<span class="smini-hidden desc">
Students Examinations Registration System
</span>
</a>
</div>
</div>
<div class="js-sidebar-scroll">
<div class="content-side">

<div class="text-center"><img class="mb-3 center_img" src="storage/images/misc/<?php echo $info['logo']; ?>" height="140" alt="School Logo"></div>

<ul class="nav-main">

<?php require_once 'includes/header.php'; ?>

</ul>
</div>
</div>
</nav>
<header id="page-header">
<div class="content-header">
<div class="space-x-1">
<button type="button" class="btn btn-alt-secondary" data-toggle="layout" data-action="sidebar_toggle">
<i class="fa fa-fw fa-bars"></i>
</button>
</div>
<div class="space-x-1">
<div class="dropdown d-inline-block">
<button type="button" class="btn btn-alt-secondary" id="page-header-user-dropdown" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
<i class="fa fa-fw fa-user d-sm-none"></i>
<span class="d-none d-sm-inline-block"><?php echo $profile['first_name'].' '.$profile['last_name']; ?></span>
<i class="fa fa-fw fa-angle-down opacity-50 ms-1 d-none d-sm-inline-block"></i>
</button>
<div class="dropdown-menu dropdown-menu-end p-0" aria-labelledby="page-header-user-dropdown">
<div class="bg-primary-dark rounded-top fw-semibold text-white text-center p-3">
My Profile
</div>
<div class="p-2">
<a class="dropdown-item" href="app/account">
<i class="far fa-fw fa-user me-1"></i> Account Settings
</a>
<div role="separator" class="dropdown-divider"></div>
<a class="dropdown-item" href="app/logout">
<i class="far fa-fw fa-arrow-alt-circle-left me-1"></i> Log Out
</a>
</div>
</div>
</div>
</div>
</div>
</header>
<main id="main-container">
<div class="content">

<div class="row mb-4">
<div class="col-xl-6 col-l-6 col-md-12 col-sm-12">
<div class="block block-rounded">
<div class="block-content">
<h2 class="content-heading pt-0"><i class="fa fa-fw fa-user text-muted me-1"></i> Account Information</h2>
<form autocomplete="off" class="app_frm" action="app/routes/update_profile" method="POST">
<div class="mb-2">
<label class="form-label">First Name</label>
<input type="text" value="<?php echo $profile['first_name']; ?>" required class="form-control" name="first_name" placeholder="Enter first name">
</div>
<div class="mb-2">
<label class="form-label">Last Name</label>
<input type="text" value="<?php echo $profile['last_name']; ?>" required class="form-control" name="last_name" placeholder="Enter last name">
</div>
<div class="mb-2">
<label class="form-label">Gender</label>
<select required class="form-control" name="gender">
<option value="" selected disabled>Select Gender</option>
<option <?php echo $profile['gender'] == 'Male' ? ' selected ' : ''; ?> value="Male">Male</option>
<option <?php echo $profile['gender'] == 'Female' ? ' selected ' : ''; ?> value="Female">Female</option>
</select>
</div>
<div class="mb-3">
<label class="form-label">Email Address</label>
<input type="email" value="<?php echo $profile['email']; ?>" required class="form-control" name="email" placeholder="Enter email address">
</div>
<div class="mb-4"><button type="submit" name="submit" value="1" class="btn w-100 btn-primary app_btn">Save Changes</button>
</div>
<?= $waf->csrf_field('update_profile.php', 600) ?>
</form>

</div>
</div>
</div>
<div class="col-xl-6 col-l-6 col-md-12 col-sm-12">
<div class="block block-rounded">
<div class="block-content">
<h2 class="content-heading pt-0"><i class="fa fa-fw fa-asterisk text-muted me-1"></i> Change Password</h2>
<form autocomplete="off" class="app_frm" action="app/routes/change_password" method="POST">
<div class="mb-2">
<label class="form-label">Current Password</label>
<div class="input-group">
<input id="cpass" type="password" class="form-control" name="current_pw" placeholder="Enter your current password">
<span class="input-group-text">
<i class="fa fa-lock"></i>
</span>
</div>
</div>
<div class="mb-2">
<label class="form-label">New Password</label>
<div class="input-group">
<input id="npass" type="password" class="form-control" name="new_pw" placeholder="Enter your new password">
<span class="input-group-text">
<i class="fa fa-lock"></i>
</span>
</div>
</div>

<div class="mb-3">
<label class="form-label">Confirm New Password</label>
<div class="input-group">
<input id="cnpass" type="password" class="form-control" name="confirm_new_pw" placeholder="Confirm your new password">
<span class="input-group-text">
<i class="fa fa-lock"></i>
</span>
</div>
</div>

<div class="mb-4"><button id="sub_btnp" type="submit" name="submit" value="1" class="btn w-100 btn-primary app_btn">Change Password</button>
</div>
<?= $waf->csrf_field('change_password.php', 600) ?>
</form>

</div>
</div>
</div>
</div>

</div>
</main>
<footer id="page-footer" class="bg-body-light">
<div class="content py-0">
<div class="row fs-sm">
<div class="col-sm-6 order-sm-2 mb-1 mb-sm-0 text-center text-sm-end">
<?php echo $info['name']; ?>
</div>
<div class="col-sm-6 order-sm-1 text-center text-sm-start">
<a class="fw-semibold">Students Examinations Registration System</a> &copy; <span data-toggle="year-copy"></span>
</div>
</div>
</div>
</footer>
</div>
<script src="assets/js/main.js"></script>
<script src="assets/js/lib/jquery.min.js"></script>
<script src="assets/js/forms.js"></script>
<script src="assets/js/plugins/sweetalert2/sweetalert2.min.js"></script>
<?php require_once('includes/check_reply.php'); ?>
</body>
</html>
<?php

}else{

header("location:../");

}
?>
