<?php
session_start();
require 'classes/database_class.php';
require 'classes/util.php';
require 'classes/application_class.php';
require_once 'classes/intake_class.php';
require_once 'const/fees_config.php';

$intake = new intake;
$application = new application;
$country_list = $application->get_countries();
$intake_list = $intake->get_intakes();
$programme_types = $application->get_programme_types();



$db = new database;
$util = new util;
$env = $util->env();


if (isset($_SESSION['application'])) {

if (!isset($_SESSION['application']['reference'])) {
$_SESSION['application']['reference'] = $util->generateReference();
}

if ($_SESSION['application']['nation'] == "Zambia") {

if ($_SESSION['application']['category'] == 3) {

$app_fee = $local_masters;

}elseif ($_SESSION['application']['category'] == 4) {

$app_fee = $local_phd;

}else{

$app_fee = $local_diploma_degree;

}

}else{


if ($_SESSION['application']['category'] == 3) {

$app_fee = $international_masters;

}elseif ($_SESSION['application']['category'] == 4) {

$app_fee = $international_phd;

}else{

$app_fee = $international_diploma_degree;

}


}

$_SESSION['current_fee'] = $app_fee;

if ((isset($_SERVER['HTTPS']) &&   (($_SERVER['HTTPS'] == 'on'))) || (isset($_SERVER['HTTPS']) && $_SERVER['SERVER_PORT'] == 443))
{
$call_url = str_replace("app/index.php","app/core/process_fw", 'https://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF']);
}
else
{
$call_url = str_replace("app/index.php","app/core/process_fw", 'http://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF']);
}

if ((isset($_SERVER['HTTPS']) &&   (($_SERVER['HTTPS'] == 'on'))) || (isset($_SERVER['HTTPS']) && $_SERVER['SERVER_PORT'] == 443))
{
$call_url_dpo = str_replace("payment","core/process_dpo", 'https://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF']);
$cancel_url_dpo = str_replace("payment","payment", 'https://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF']);
}
else
{
$call_url_dpo = str_replace("payment","core/process_dpo", 'http://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF']);
$cancel_url_dpo = str_replace("payment","payment", 'http://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF']);
}

$_SESSION['domain'] = $call_url;
$_SESSION['dpo_links'] = [$call_url_dpo, $cancel_url_dpo];
$_SESSION['act_fee'] = $app_fee;
?>
<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1.0">
<title><?php echo $env['name'].' - Payment'; ?></title>
<meta name="description" content="<?php echo $env['alias']; ?>">
<meta name="robots" content="noindex, nofollow">
<link rel="shortcut icon" href="assets/img/<?php echo $env['logo']; ?>">
<link rel="stylesheet" href="assets/js/plugins/select2/css/select2.min.css">
<link rel="stylesheet" id="css-main" href="assets/css/dashmix.min-5.4.css">

<link rel="stylesheet" href="assets/js/plugins/dropzone/min/dropzone.min.css">
<link rel="stylesheet" href="assets/js/plugins/bootstrap-datepicker/css/bootstrap-datepicker3.min.css">
<link type="text/css" rel="stylesheet" href="assets/loader/waitMe.css">
<link rel="stylesheet" href="whatsapp/venom-button.min.css" />
</head>
<body>
<div id="page-loader"><div class="loader-ring"></div></div>
<div id="page-container">
<main id="main-container">
<div>
<div class="row g-0 justify-content-center bg-primary-dark-op">
<div class="hero-static col-sm-8 col-md-8 col-l-8 col-xl-8 d-flex align-items-center p-2 px-sm-0">
<div class="block block-transparent block-rounded w-100 mb-0 overflow-hidden">
<div class="block-content block-content-full px-lg-5 px-xl-6 py-1 py-md-5 py-lg-6 bg-body-extra-light">
<div class="mb-2 text-center">
<img width="150" src="assets/img/<?php echo $env['logo']; ?>" class="mb-2"><br>
<a class=" fw-bold fs-3" >
<span class="text-dark"> <?php echo $env['name']; ?></span></a>
<p class="text-uppercase fw-bold fs-sm text-muted"><?php echo $env['alias']; ?></p>
<p class="text-muted">Kindly pay the application fees.</p>
</div>

<div class="block-content block-content-full space-y-3">
<div class="block block-rounded">
<div class="col-lg-12">
<div class="block block-rounded block-bordered">

<div class="block-content">
<div class="fs-4 mb-1"><?php echo $_SESSION['application']['sname'].' '.$_SESSION['application']['fname']; ?></div>
<address class="fs-sm">
<?php echo $_SESSION['application']['reference']; ?><br>
<?php echo $_SESSION['application']['email']; ?><br>
<?php echo $_SESSION['application']['phone']; ?><br><br>

<?php
if (!empty($env['DPO_COMPANY_TOKEN'])) {
?>
<form action="core/pay_with_dpo.php" method="post" autocomplete="off">
<button type="submit" class="btn btn-primary push" >Pay <?php echo number_format($app_fee); ?> Online</button>
</form>
<?php
}
?>
</address>
</div>
</div>
</div>
</div>
</div>
<center><img title="We accept payments through MTN/AIRTEL Money and VISA(Any Credit and Debit ATM BANK CARD)" alt="We accept payments through MTN/AIRTEL Money and VISA(Any Credit and Debit ATM BANK CARD)" height='45' src="assets/img/pm.png" class="mb-2">
<br><i>We accept payments through MTN/AIRTEL Money and VISA(Any Credit and Debit ATM BANK CARD)</i>
</center><br>
</div>

</div>
</div>
</div>
</div>
</main>
</div>
<div id="whatsappButton"></div>
<script src="assets/js/gru_oas.js"></script>
<script src="assets/js/lib/jquery.min.js"></script>
<script src="assets/loader/waitMe.js"></script>
<script src="assets/js/custom.js"></script>
<script src="assets/js/sweetalert.min.js"></script>
<script src="assets/js/plugins/select2/js/select2.full.min.js"></script>
<script src="assets/js/plugins/dropzone/min/dropzone.min.js"></script>
<script src="assets/js/plugins/bootstrap-datepicker/js/bootstrap-datepicker.min.js"></script>
<script src="assets/js/plugins/jquery.maskedinput/jquery.maskedinput.min.js"></script>
<script src="https://pay.lenco.co/js/v1/inline.js"></script>
<script src="whatsapp/venom-button.min.js"></script>
<script>

function getPaidWithLenco() {
LencoPay.getPaid({
key: '<?php echo $env['lenco_public_key']; ?>',
reference: '<?php echo $_SESSION['application']['reference']; ?>',
email: '<?php echo $_SESSION['application']['email']; ?>',
amount: <?php echo $app_fee; ?>,
currency: "ZMW",
channels: ["card", "mobile-money"],
customer: {
firstName: "<?php echo $_SESSION['application']['fname']; ?>",
lastName: "<?php echo $_SESSION['application']['sname']; ?>",
phone: "<?php echo $_SESSION['application']['phone']; ?>",
},
onSuccess: function (response) {

const reference = response.reference;
window.location.href = "core/verify_txn?response=" + response.reference;
},
onClose: function () {

},
onConfirmationPending: function () {

},
});
}
</script>
<script>
$('#whatsappButton').venomButton({
phone: '260977462120',
popupMessage: 'Hello, how can we help you?',
message: "",
showPopup: true,
position: "right",
linkButton: false,
headerTitle: 'Live Chat Support 24/7',
headerColor: '#25d366',
backgroundColor: '#25d366',
});
</script>
<?php $db->kill_conn(); require_once('assets/includes/check_reply.php'); ?>
</body>
</html>

<?php
}else{

header("location:./");

}
?>
