<?php
session_start();
require 'classes/database_class.php';
require 'classes/util.php';

$db = new database;
$util = new util;
$env = $util->env();
?>
<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1.0">
<title><?php echo $env['name'].' - Create Account'; ?></title>
<meta name="description" content="<?php echo $env['alias']; ?>">
<meta name="robots" content="noindex, nofollow">
<link rel="shortcut icon" href="assets/img/<?php echo $env['logo']; ?>">
<link rel="stylesheet" id="css-main" href="assets/css/dashmix.min-5.4.css">
<link type="text/css" rel="stylesheet" id="css-theme" href="assets/css/themes/xsmooth.min-5.7.css">
<link type="text/css" rel="stylesheet" href="assets/loader/waitMe.css">
</head>
<body>
<div id="page-loader" class="show"></div>
<div id="page-container">
<main id="main-container">
<div>
<div class="row g-0 justify-content-center bg-primary-dark-op">
<div class="hero-static col-sm-8 col-md-6 col-xl-3 d-flex align-items-center p-2 px-sm-0">
<div class="block block-transparent block-rounded w-100 mb-0 overflow-hidden">
<div class="block-content block-content-full px-lg-5 px-xl-6 py-1 py-md-5 py-lg-6 bg-body-extra-light">
<div class="mb-2 text-center">
<img width="150" src="assets/img/<?php echo $env['logo']; ?>" class="mb-2"><br>
<a class=" fw-bold fs-3" >
<span class="text-dark"> <?php echo $env['name']; ?></span></a>
<p class="text-uppercase fw-bold fs-sm text-muted"><?php echo $env['alias']; ?></p>
</div>
<form class="app_frm" action="core/onboard" autocomplete="off" method="POST">
<div class="mb-2">
<div class="input-group input-group-lg">
<input type="text" class="form-control" name="fname" required placeholder="Enter your first name">
</div>
</div>
<div class="mb-2">
<div class="input-group input-group-lg">
<input type="text" class="form-control" name="lname" required placeholder="Enter your lastname">
</div>
</div>
<div class="mb-2">
<div class="input-group input-group-lg">
<select class="form-control" name="gender" required placeholder="Enter your first name">
<option value="" selected disabled>Select Gender</option>
<option value="Male">Male</option>
<option value="Female">Female</option>
</select>
</div>
</div>
<div class="mb-2">
<div class="input-group input-group-lg">
<input type="email" class="form-control" name="email" required placeholder="Enter your email address">
</div>
</div>
<div class="mb-3">
<div class="input-group input-group-lg">
<input type="password" class="form-control" name="password" required placeholder="Enter your login password">
</div>
</div>

<div class="mb-4">
<button type="submit" class="btn app_btn w-100 btn-hero btn-primary">Create Account</button>
</div>

<b>Forgot your password? <a href="reset_pw">Reset Password</a></b><br>
<b>Already have an account? <a href="./">Sign In</a></b>
</form>
</div>

</div>
</div>
</div>
</div>
</main>
</div>
<script src="assets/js/gru_oas.js"></script>
<script src="assets/js/lib/jquery.min.js"></script>
<script src="assets/loader/waitMe.js"></script>
<script src="assets/js/custom.js"></script>
<script src="assets/js/sweetalert.min.js"></script>
<?php $db->kill_conn(); require_once('assets/includes/check_reply.php'); ?>
</body>
</html>
