<?php
session_start();
chdir('../');
require 'classes/database_class.php';
require 'classes/util.php';
require 'classes/users_class.php';


use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require 'mail/src/Exception.php';
require 'mail/src/PHPMailer.php';
require 'mail/src/SMTP.php';

$util = new util;
$users = new users;
$env = $util->env();

if ($_SERVER['REQUEST_METHOD'] === 'POST' && $_POST['csrf_token'] == $_SESSION['csrf_token']) {

$email = $util->sanitize($_POST['email']);

$account_details = $users->auth_user($email);

if (count($account_details) > 0) {

if ($account_details[0]['status'] == "0") {

$util->setMessage("error", "Account is not enabled");
header("location:../reset_pw");
}else{

$new_password = $util->genRandString(8);
$new_password_hashed = password_hash($new_password, PASSWORD_BCRYPT);

require 'email_templates/reset_password.php';

$mail = new PHPMailer;
$mail->SMTPOptions = array(
'ssl' => array(
'verify_peer' => false,
'verify_peer_name' => false,
'allow_self_signed' => true
)
);

$mail->isSMTP();
$mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
$mail->Host = $env['smtp_server'];
$mail->SMTPAuth = true;
$mail->Username = $env['smtp_username'];
$mail->Password = $env['smtp_password'];
$mail->SMTPSecure = $env['smtp_enctyption'];
$mail->Port = $env['smtp_port'];

$mail->setFrom($env['smtp_username'], $env['name']);
$mail->addAddress($email);
$mail->isHTML(true);

$mail->Subject = 'Reset Password';
$mail->Body    = $msg;
$mail->AltBody = $msg;


if(!$mail->send()) {
$er = '' . $mail->ErrorInfo.'';
$er = str_replace("https://github.com/PHPMailer/PHPMailer/wiki/Troubleshooting", "", $er);

$util->setMessage("error", $er);
header("location:../reset_pw");

}else{

$users->update_password($new_password_hashed, $account_details[0]['id']);

$util->setMessage("success", "Please check your email");
header("location:../reset_pw");
}

}

}else{
$util->setMessage("error", "Account was not found");
header("location:../reset_pw");
}


}else{
http_response_code(403);
}

?>
