<?php
session_start();
chdir('../');
require 'classes/database_class.php';
require 'classes/util.php';
require 'classes/users_class.php';
require 'classes/session_class.php';

$util = new util;
$users = new users;
$session = new session;
$env = $util->env();

if ($_SERVER['REQUEST_METHOD'] === 'POST' && $_POST['csrf_token'] == $_SESSION['csrf_token']) {

$email = $util->sanitize($_POST['email']);
$password = $util->sanitize($_POST['password']);

$account_details = $users->auth_user($email);

if (count($account_details) > 0) {

if ($account_details[0]['status'] == "0") {

$util->setMessage("error", "Account is not enabled");
header("location:../admin");
}else{

if (password_verify($password, $account_details[0]['hashed_pw'])) {

if ($session->authorize_user($account_details)) {
header("location:../app?page=dashboard");
}else{
$util->setMessage("error", "An error occured");
header("location:../admin");
}

}else{

$util->setMessage("error", "Password is not valid");
header("location:../admin");
}
}

}else{
$util->setMessage("error", "Email address is not valid");
header("location:../admin");
}


}else{
http_response_code(403);
}

?>
