<?php
class intake extends database {

public function add_intake($name, $status) {
$sql = 'INSERT INTO intakes (intake_name, status) VALUES (?,?)';
$stmt = $this->conn->prepare($sql);
$stmt->execute([$name, $status]);
return true;
}


public function check_intake($name) {
$sql = 'SELECT * FROM intakes WHERE intake_name = ?';
$stmt = $this->conn->prepare($sql);
$stmt->execute([$name]);
$result = $stmt->fetchAll();
if (count($result) < 1) { return true; } else { return false;}
}

public function check_intake2($name, $id) {
$sql = 'SELECT * FROM intakes WHERE intake_name = ? AND id != ?';
$stmt = $this->conn->prepare($sql);
$stmt->execute([$name, $id]);
$result = $stmt->fetchAll();
if (count($result) < 1) { return true; } else { return false;}
}

public function get_intake($id) {
$sql = 'SELECT * FROM intakes WHERE id = ?';
$stmt = $this->conn->prepare($sql);
$stmt->execute([$id]);
$result = $stmt->fetchAll();
return $result;
}

public function get_all_intakes() {
$sql = 'SELECT * FROM intakes ORDER BY ID DESC';
$stmt = $this->conn->prepare($sql);
$stmt->execute();
$result = $stmt->fetchAll();
return $result;
}

public function get_intakes() {
$sql = 'SELECT * FROM intakes ORDER BY ID ASC';
$stmt = $this->conn->prepare($sql);
$stmt->execute();
$result = $stmt->fetchAll();
return $result;
}

public function update_intake($name, $status, $id) {
$sql = 'UPDATE intakes SET intake_name = ?, status = ? WHERE id = ?';
$stmt = $this->conn->prepare($sql);
$stmt->execute([$name, $status, $id]);
return true;
}

public function delete_intake($id) {
$sql = 'DELETE FROM intakes WHERE id = ?';
$stmt = $this->conn->prepare($sql);
$stmt->execute([$id]);
return true;
}


}
?>
