<?php
session_start();
chdir('../../');
require 'classes/database_class.php';
require 'classes/util.php';
require 'classes/programmes_class.php';
require 'classes/application_class.php';


$util = new util;
$programmes = new programmes;
$application = new application;
$env = $util->env();

if ($_SERVER['REQUEST_METHOD'] === 'POST' && $_POST['csrf_token'] == $_SESSION['csrf_token']) {

$id = $util->sanitize($_POST['id']);
$programme_details = $programmes->get_programme($id);
$programme_types = $application->get_programme_types();
?>

<div class="row mb-2">
<label class="col-sm-4 col-form-label">Programme Name</label>
<div class="col-sm-8">
<input name="name" value="<?php echo $programme_details[0]['name']; ?>" required type="text" placeholder="Enter programme name here" class="form-control ">
</div>
</div>

<div class="row mb-2">
<label class="col-sm-4 col-form-label">Programme Category</label>
<div class="col-sm-8">
<select name="category" required class="form-control ">
<option value="" selected disabled>Select Category</option>
<?php
foreach ($programme_types as $type) {
?><option <?php if ($programme_details[0]['type'] == $type['id']) { print ' selected '; } ?> value="<?php echo $type['id']; ?>"><?php echo $type['name']; ?></option><?php
}
?>
</select>
</div>
</div>

<input type="hidden" name="id" value="<?php echo $id; ?>">
<?php

}

?>
