<?php
session_start();
chdir('../../');
require 'classes/database_class.php';
require 'classes/util.php';
require 'classes/intake_class.php';


$util = new util;
$intake = new intake;
$env = $util->env();

if ($_SERVER['REQUEST_METHOD'] === 'POST' && $_POST['csrf_token'] == $_SESSION['csrf_token']) {

$id = $util->sanitize($_POST['id']);
$details = $intake->get_intake($id);
?>

<div class="row mb-2">
<label class="col-sm-4 col-form-label">Intake Name</label>
<div class="col-sm-8">
<input name="name" value="<?php echo $details[0]['name']; ?>" required type="text" placeholder="Enter intake name" class="form-control ">
</div>
</div>
<div class="row mb-3">
<label class="col-sm-4 col-form-label">Status</label>
<div class="col-sm-8">
<select name="status" required class="form-control ">
<option value="" selected disabled>Select Status</option>
<option <?php echo $details[0]['status'] == "1" ? ' selected ' : ''; ?> value="1">Enabled</option>
<option <?php echo $details[0]['status'] == "0" ? ' selected ' : ''; ?> value="0">Disabled</option>
</select>
</div>
</div>

<input type="hidden" name="id" value="<?php echo $id; ?>">
<?php

}

?>
