<?php
session_start();
chdir('../../');
require 'classes/database_class.php';
require 'classes/util.php';
require 'classes/application_class.php';

$util = new util;
$application = new application;
$env = $util->env();

if ($_SERVER['REQUEST_METHOD'] === 'POST' && $_POST['csrf_token'] == $_SESSION['csrf_token']) {

$id = $util->sanitize($_POST['id']);
$src = $util->sanitize($_POST['src']);
$personal_details = $application->get_personal_details($id);
$application_fee = $application->get_application_fee($id);
$address_details = $application->get_address_details($id);
$education_details = $application->get_education_details($id);
$programme_choices = $application->get_programme_choices($id);

$basic_profile = $application->get_basic_profile($id);


?>
<div class="block block-rounded row g-0">
<ul class="nav nav-tabs nav-tabs-block flex-md-column col-md-4" role="tablist">
<li class="nav-item d-md-flex flex-md-column" role="presentation">
<button type="button" class="nav-link text-md-start active" id="btabs-vertical-personal-tab" data-bs-toggle="tab" data-bs-target="#btabs-vertical-personal" role="tab" aria-controls="btabs-vertical-personal" aria-selected="true">
<i class="fa fa-fw fa-user opacity-50 me-1 d-none d-sm-inline-block"></i> Personal Details
</button>
</li>
<li class="nav-item d-md-flex flex-md-column" role="presentation">
<button type="button" class="nav-link text-md-start" id="btabs-vertical-fees-tab" data-bs-toggle="tab" data-bs-target="#btabs-vertical-fees" role="tab" aria-controls="btabs-vertical-fees" aria-selected="false" tabindex="-1">
<i class="fa fa-fw fa-money-bill-wave opacity-50 me-1 d-none d-sm-inline-block"></i> Application Fees
</button>
</li>
<li class="nav-item d-md-flex flex-md-column" role="presentation">
<button type="button" class="nav-link text-md-start" id="btabs-vertical-address-tab" data-bs-toggle="tab" data-bs-target="#btabs-vertical-address" role="tab" aria-controls="btabs-vertical-address" aria-selected="false" tabindex="-1">
<i class="fa fa-fw fa-home opacity-50 me-1 d-none d-sm-inline-block"></i> Address Details
</button>
</li>
<li class="nav-item d-md-flex flex-md-column" role="presentation">
<button type="button" class="nav-link text-md-start" id="btabs-vertical-education-tab" data-bs-toggle="tab" data-bs-target="#btabs-vertical-education" role="tab" aria-controls="btabs-vertical-education" aria-selected="false" tabindex="-1">
<i class="fa fa-fw fa-graduation-cap opacity-50 me-1 d-none d-sm-inline-block"></i> Education Details
</button>
</li>
<li class="nav-item d-md-flex flex-md-column" role="presentation">
<button type="button" class="nav-link text-md-start" id="btabs-vertical-status-tab" data-bs-toggle="tab" data-bs-target="#btabs-vertical-status" role="tab" aria-controls="btabs-vertical-status" aria-selected="false" tabindex="-1">
<i class="fa fa-fw fa-pen opacity-50 me-1 d-none d-sm-inline-block"></i> Update Status
</button>
</li>
</ul>
<div class="tab-content col-md-8">
<div class="block-content tab-pane active" id="btabs-vertical-personal" role="tabpanel" aria-labelledby="btabs-vertical-home-personal" tabindex="0">
<h4 class="fw-semibold">Personal Details</h4>
<div class="mb-1">
<label class="form-label">Surname</label>
<input type="text" readonly class="form-control-plaintext" value="<?php echo $personal_details[0]['surname']; ?>">
</div>
<div class="mb-1">
<label class="form-label" >Forname(s)</label>
<input type="text" readonly class="form-control-plaintext" value="<?php echo $personal_details[0]['fornames']; ?>">
</div>
<div class="mb-1">
<label class="form-label" >NRC Number</label>
<input type="text" readonly class="form-control-plaintext" value="<?php echo !empty($personal_details[0]['nrc']) ? $personal_details[0]['nrc'] : "Not Applicable"; ?>">
</div>
<div class="mb-1">
<label class="form-label" >Passport Number</label>
<input type="text" readonly class="form-control-plaintext" value="<?php echo !empty($personal_details[0]['passport_no']) ? $personal_details[0]['passport_no'] : "Not Applicable"; ?>">
</div>
<div class="mb-1">
<label class="form-label" >Birthday</label>
<input type="text" readonly class="form-control-plaintext" value="<?php echo date("F d, Y", strtotime($personal_details[0]['dob'])); ?>">
</div>
<div class="mb-1">
<label class="form-label" >Gender</label>
<input type="text" readonly class="form-control-plaintext" value="<?php echo $basic_profile[0]['gender']; ?>">
</div>
<div class="mb-1">
<label class="form-label" >Nationality</label>
<input type="text" readonly class="form-control-plaintext" value="<?php echo $personal_details[0]['nationality']; ?>">
</div>
<div class="mb-1">
<label class="form-label" >Mobile Number</label>
<input type="text" readonly class="form-control-plaintext" value="<?php echo $personal_details[0]['mobile_no']; ?>">
</div>
<div class="mb-1">
<label class="form-label" >Email Address</label>
<input type="text" readonly class="form-control-plaintext" value="<?php echo $basic_profile[0]['email']; ?>">
</div>
<div class="mb-1">
<label class="form-label" >Disability</label>
<input type="text" readonly class="form-control-plaintext" value="<?php echo $personal_details[0]['disability'] == "1" ? "Yes" : "No"; ?>">
</div>
<div class="mb-1">
<label class="form-label" >Nature of the disability</label>
<input type="text" readonly class="form-control-plaintext" value="<?php echo !empty($personal_details[0]['nature']) ? $personal_details[0]['nature'] : "Not Applicable"; ?>">
</div>

<div class="mb-1">
<label class="form-label" >Applying For</label>
<input type="text" readonly class="form-control-plaintext" value="<?php echo $personal_details[0]['name']; ?>">
</div>

<div class="mb-1">
<label class="form-label" >Academic Intake</label>
<input type="text" readonly class="form-control-plaintext" value="<?php echo $personal_details[0]['intake_name']; ?>">

</div>

</div>



<div class="block-content tab-pane" id="btabs-vertical-fees" role="tabpanel" aria-labelledby="btabs-vertical-fees-tab" tabindex="0">
<h4 class="fw-semibold">Application Fees</h4>

<?php

if (count($application_fee) < 1) {

?>

<div class="alert alert-warning" role="alert">
<p class="mb-0">Application fees not paid <strong><?php echo $personal_details[0]['nationality'] == "Zambia" ? "ZMW 250" : "ZMW 840"; ?></strong></p>

</div>
<?php

}else{

$pay_details = json_decode($application_fee[0]['callback_data'], TRUE);

?>
<div class="alert alert-success" role="alert">
<p class="mb-0">Application fees paid successfully.<br>
<b>ID</b> : <?php echo strtoupper($pay_details['data']['id']); ?><br>
<b>AMOUNT</b> : <?php echo $pay_details['data']['amount']; ?> ZMW<br>
<b>Initiated At</b> : <?php echo strtoupper($pay_details['data']['initiatedAt']); ?><br>
<b>Completed At</b> : <?php echo strtoupper($pay_details['data']['completedAt']); ?><br>
</p>

</div>
<?php

}

?>
</div>


<div class="block-content tab-pane" id="btabs-vertical-address" role="tabpanel" aria-labelledby="btabs-vertical-address-tab" tabindex="0">
<h4 class="fw-semibold">Address Details</h4>
<div class="mb-1">
<label class="form-label">Residential</label>
<input type="text" readonly class="form-control-plaintext" value="<?php echo $address_details[0]['residential']; ?>">
</div>
<div class="mb-1">
<label class="form-label" >Postal Address</label>
<input type="text" readonly class="form-control-plaintext" value="<?php echo $address_details[0]['postal_address']; ?>">
</div>
<div class="mb-1">
<label class="form-label" >Next of Kin</label>
<input type="text" readonly class="form-control-plaintext" value="<?php echo $address_details[0]['next_of_kin']; ?>">
</div>
<div class="mb-1">
<label class="form-label" >Next of Kin Relationship</label>
<input type="text" readonly class="form-control-plaintext" value="<?php echo $address_details[0]['nok_relationship']; ?>">
</div>
<div class="mb-1">
<label class="form-label" >Next of Kin Phone</label>
<input type="text" readonly class="form-control-plaintext" value="<?php echo $address_details[0]['nok_phone']; ?>">
</div>
<div class="mb-1">
<label class="form-label" >Next of Kin Residential</label>
<input type="text" readonly class="form-control-plaintext" value="<?php echo $address_details[0]['nok_residential']; ?>">
</div>
<div class="mb-1">
<label class="form-label" >Next of Kin Postal Address</label>
<input type="text" readonly class="form-control-plaintext" value="<?php echo $address_details[0]['nok_postal_address']; ?>">
</div>
</div>


<div class="block-content tab-pane" id="btabs-vertical-education" role="tabpanel" aria-labelledby="btabs-vertical-education-tab" tabindex="0">
<h4 class="fw-semibold">Education Details</h4>
<div class="mb-1">
<label class="form-label">High School</label>
<input type="text" readonly class="form-control-plaintext" value="<?php echo $education_details[0]['hig_school']; ?>">
</div>
<div class="mb-1">
<label class="form-label" >Examination Number</label>
<input type="text" readonly class="form-control-plaintext" value="<?php echo $education_details[0]['exam_number']; ?>">
</div>
<div class="mb-1">
<label class="form-label" >Completion Year</label>
<input type="text" readonly class="form-control-plaintext" value="<?php echo $education_details[0]['completion_year']; ?>">
</div>
<div class="mb-1">
<label class="form-label" >Mode of Study</label>
<input type="text" readonly class="form-control-plaintext" value="<?php echo $education_details[0]['mode_of_study']; ?>">
</div>
<div class="mb-1">
<label class="form-label" >Programme Choice 1</label>
<input type="text" readonly class="form-control-plaintext" value="<?php echo $application->get_programme_name($education_details[0]['choice_1']); ?>">
</div>
<div class="mb-1">
<label class="form-label" >Programme Choice 2</label>
<input type="text" readonly class="form-control-plaintext" value="<?php echo $application->get_programme_name($education_details[0]['choice_2']); ?>">
</div>
<div class="mb-1">
<label class="form-label" >Programme Choice 3</label>
<input type="text" readonly class="form-control-plaintext" value="<?php echo $application->get_programme_name($education_details[0]['choice_3']); ?>">
</div>

<div class="mb-1">
<label class="form-label" >Academic Records</label>
<ol>
<?php
$unlink_dir = 'uploads/FOLDER_'.$id.'/';
$files = glob($unlink_dir.'*.{grudoc}', GLOB_BRACE);

foreach($files as $file) {

$secfile = base64_encode($file);
$ext = str_replace(".","",strrchr($file, '.'));
$title = str_replace('uploads/FOLDER_'.$id.'/',"",$file);
echo "<li><a target='_blank' href='app?page=docview&file=$secfile'>".pathinfo($title, PATHINFO_FILENAME)."</a></li>";
?>

<?php
}

?>
</ol>
</div>
</div>

<div class="block-content tab-pane" id="btabs-vertical-status" role="tabpanel" aria-labelledby="btabs-vertical-status-tab" tabindex="0">
<h4 class="fw-semibold">Update Application Status</h4>



<div class="row">
<div class="col-lg-12 col-sm-12 mb-3">
<label class="form-label">Status</label>
<select name="status" required class="form-control">
<option <?php if ($basic_profile[0]['completed'] == "1") { print ' selected '; } ?> value="1">Pending</option>
<option <?php if ($basic_profile[0]['completed'] == "2") { print ' selected '; } ?> value="2">Approved</option>
<option <?php if ($basic_profile[0]['completed'] == "3") { print ' selected '; } ?> value="3">Denied</option>
</select>
</div>

</div>

<input type="hidden" name="app_id" value="<?php echo $id; ?>">
<input type="hidden" name="red" value="<?php echo $src; ?>">
<div class="mb-2">
<button type="submit" class="btn btn-primary">Save Changes</button>
</div>



</div>

</div>
</div>

<?php

}

?>
