<?php
session_start();
chdir('../../');
require 'classes/database_class.php';
require 'classes/util.php';
require 'classes/users_class.php';
require 'classes/session_class.php';
require 'classes/accounts_class.php';

$db = new database;
$util = new util;
$users = new users;
$session = new session;
$accounts = new accounts;
$env = $util->env();

if ($session->is_logged()) {

$table = <<<EOT
(
SELECT * FROM users WHERE level = '2'
) temp
EOT;

$primaryKey = 'id';

$columns = array(
array( 'db' => 'fname',   'dt' => 0 ),
array( 'db' => 'lname',   'dt' => 1 ),
array( 'db' => 'gender',   'dt' => 2 ),
array( 'db' => 'email',   'dt' => 3 ),
array(
'db'        => 'status',
'dt'        => 4,
'formatter' => function( $d, $row ) {
switch ($d) {
case '0':
return '<span class="badge rounded-pill bg-warning">BLOCKED</span>';
break;

case '1':
return '<span class="badge rounded-pill bg-success">ACTIVE</span>';
break;
}
}
),

array(
'db'        => 'id',
'dt'        => 5,
'formatter' => function( $d, $row ) {
return "
<button onclick='get_user($d);' type='button' class='btn btn-primary btn-sm' data-bs-toggle='modal' data-bs-target='#modal-edit' data-bs-keyboard='false' data-bs-backdrop='static'>Edit</button>
<button onclick='drop(".htmlspecialchars_decode('&#039')."app/core/delete_user?id=$d".htmlspecialchars_decode('&#039').",".htmlspecialchars_decode('&#039')."Delete User?".htmlspecialchars_decode('&#039').");' type='button' class='btn btn-danger btn-sm'>Delete</button>
";
}
)
);


$sql_details = array(
'user' => $db->_db[1],
'pass' => $db->_db[2],
'db'   => $db->_db[3],
'host' => $db->_db[0]
,'charset' => 'utf8'
);

require('includes/ssp.class.php');

echo json_encode(
SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns )
);


}else{
http_response_code(403);
}
?>
