<?php
session_start();
chdir('../../');
require 'classes/database_class.php';
require 'classes/util.php';
require 'classes/users_class.php';
require 'classes/session_class.php';
require 'classes/accounts_class.php';

$db = new database;
$util = new util;
$users = new users;
$session = new session;
$accounts = new accounts;
$env = $util->env();

if ($session->is_logged()) {

$table = <<<EOT
(
SELECT * FROM intakes ORDER BY id DESC
) temp
EOT;

$primaryKey = 'id';

$columns = array(
array( 'db' => 'intake_name',   'dt' => 0 ),
array(
'db'        => 'status',
'dt'        => 1,
'formatter' => function( $d, $row ) {
switch ($d) {
case '0':
return '<span class="badge rounded-pill bg-warning">DISABLED</span>';
break;

case '1':
return '<span class="badge rounded-pill bg-success">ENABLED</span>';
break;
}
}
),

array(
'db'        => 'id',
'dt'        => 2,
'formatter' => function( $d, $row ) {
return "
<button onclick='get_intake($d);' type='button' class='btn btn-primary btn-sm' data-bs-toggle='modal' data-bs-target='#modal-edit' data-bs-keyboard='false' data-bs-backdrop='static'>Edit</button>
<button onclick='drop(".htmlspecialchars_decode('&#039')."app/core/delete_intake?id=$d".htmlspecialchars_decode('&#039').",".htmlspecialchars_decode('&#039')."Delete Intake?".htmlspecialchars_decode('&#039').");' type='button' class='btn btn-danger btn-sm'>Delete</button>
";
}
)
);


$sql_details = array(
'user' => $db->_db[1],
'pass' => $db->_db[2],
'db'   => $db->_db[3],
'host' => $db->_db[0]
,'charset' => 'utf8'
);

require('includes/ssp.class.php');

echo json_encode(
SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns )
);


}else{
http_response_code(403);
}
?>
