<?php
if (isset($is_authorized) && $is_authorized > 0 && $current_user[0]['level'] == "1" || $current_user[0]['level'] == "4") {

function convertNumberToWord($num = false) {
$num = (int)$num;
if (!$num) {
return 'zero';
}

$ones = array(
'', 'one', 'two', 'three', 'four', 'five', 'six',
'seven', 'eight', 'nine', 'ten', 'eleven', 'twelve',
'thirteen', 'fourteen', 'fifteen', 'sixteen',
'seventeen', 'eighteen', 'nineteen'
);

$tens = array(
'', '', 'twenty', 'thirty', 'forty', 'fifty',
'sixty', 'seventy', 'eighty', 'ninety'
);

$hundreds = array('', 'thousand', 'million', 'billion');

$output = '';

if ($num < 20) {
return $ones[$num];
} elseif ($num < 100) {
return $tens[intval($num / 10)] . (($num % 10) ? ' ' . $ones[$num % 10] : '');
} elseif ($num < 1000) {
return $ones[intval($num / 100)] . ' hundred' . (($num % 100) ? ' ' . convertNumberToWord($num % 100) : '');
} elseif ($num < 1000000) {
return convertNumberToWord(intval($num / 1000)) . ' thousand' . (($num % 1000) ? ' ' . convertNumberToWord($num % 1000) : '');
}

return 'number too large';
}

require 'classes/application_class.php';

$application = new application;
$country_list = $application->get_countries();
$programme_types = $application->get_programme_types();

$personal_details = $application->get_personal_details($_SESSION['app_details'][0]['app_id']);
$application_fee = $application->get_application_fee($_SESSION['app_details'][0]['app_id']);

if ($current_user[0]['level'] == "4" && count($application_fee) < 1) {
$callback = '{"status":true,"message":"","data":{"id":"c40fb0a1-d815-4c6b-8f9c-5d6ff2d99125","initiatedAt":"2025-02-27T04:45:20.968Z","completedAt":"2025-02-27T04:46:00.176Z","amount":"10.00","fee":"0.25","bearer":"merchant","currency":"ZMW","reference":"ref_1740631514","lencoReference":"250580007","type":"mobile-money","status":"successful","source":"api","reasonForFailure":null,"settlementStatus":"settled","settlement":{"id":"f575d79b-0aa0-4d19-86c5-cd4bb3b5b6dd","amountSettled":"9.75","currency":"ZMW","createdAt":"2025-02-27T04:46:00.294Z","settledAt":"2025-02-27T04:46:01.006Z","status":"settled","type":"instant","accountId":"ea6f90f9-9e94-4d2b-a7af-2ca90ff61653"},"mobileMoneyDetails":{"country":"zm","phone":"0961111111","operator":"mtn","accountName":"Francisca Reuben"},"bankAccountDetails":null,"cardDetails":null}}';
$application->bypass_fee($_SESSION['app_details'][0]['app_id'], $callback);

$application_fee = $application->get_application_fee($_SESSION['app_details'][0]['app_id']);

}

$util = new util;
$env = $util->env();
$pay_details = json_decode($application_fee[0]['callback_data'], TRUE);

if (count($application_fee) < 1) {
header("location:./?page=application_fee");
}else{

require_once('tcpdf/tcpdf.php');
ini_set('memory_limit','2048M');

class MYPDF extends TCPDF {


public function Header() {
$bMargin = $this->getBreakMargin();
$auto_page_break = $this->AutoPageBreak;
$this->SetAutoPageBreak(false, 0);
$this->SetAlpha(0.15);
$img_file = K_PATH_IMAGES.'../assets/images/logo/gru_report.png';
$this->Image($img_file, 58, 100, 90, 87, '', '', '', false, 300, '', false, false, 0);
$this->SetAlpha(10);
$this->SetAutoPageBreak($auto_page_break, $bMargin);
$this->setPageMark();

}


public function Footer() {
$this->SetY(-15);
$this->SetFont("helvetica", 'I', 8);
$this->Cell(0, 10, 'Page '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
}

}

$pdf = new MYPDF('P', PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
$pdf->SetMargins(10, 10, 10, true);

$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor($env['name']);
$pdf->SetTitle('Payment Receipt '.$_SESSION['app_details'][0]['app_id']);
$pdf->SetSubject('Payment Receipt '.$_SESSION['app_details'][0]['app_id']);
$pdf->SetKeywords('Payment Receipt '.$_SESSION['app_details'][0]['app_id']);


$pdf->setPrintHeader(true);
$pdf->setPrintFooter(true);

$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);


$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
require_once(dirname(__FILE__).'/lang/eng.php');
$pdf->setLanguageArray($l);
}

$pdf->AddPage('P');


$html = '<table width="100%" cellpadding="0" align="center">
<tr><td></td>
</tr>
<tr>
<td>
<img height="90" src="assets/img/gru_report.png">
<h5 style="font-weight:100;"><b style="font-size:13pt; padding-top:30px;">GIDEON ROBERT UNIVERSITY</b><br>
<b style="font-size:11pt;">Pot# 4018 Off Kafue Road, Lilayi, Lusaka, Zambia.</b><br>
<b style="font-size:11pt;">P.O Box</b> 770 Mandahill, Lusaka, Zambia.<br>
<b style="font-size:11pt;">Email:</b> vc@gideonrobertuniversity.com<br>
<b style="font-size:11pt;">Phone:</b> +260 969 899 875 / +260 979 966 615.<br>
<b style="font-size:11pt;">Payment Receipt</b>
</h5>
</td>
</tr>
</table>';

$pdf->writeHTMLCell(0, 0, '', '', $html, 0, 1, 0, true, '', true);

$pdf->Ln(3);

$html = '<table style="font-size:10pt;"  width="100%" cellpadding="8" align="center">
<tr>
<td align="left" width="20%">Receipt No</td>
<td align="left" width="80%">'.$pay_details['data']['id'].'</td>
</tr>

<tr>
<td align="left" width="20%">Received From</td>
<td align="left" width="80%">'.$personal_details[0]['surname'].' '.$personal_details[0]['fornames'].'</td>
</tr>

<tr>
<td align="left" width="20%">Email Address</td>
<td align="left" width="80%">'.$current_user[0]['email'].'</td>
</tr>

<tr>
<td align="left" width="20%">Mobile Phone</td>
<td align="left" width="80%">'.$personal_details[0]['mobile_no'].'</td>
</tr>

<tr>
<td align="left" width="20%">Amount</td>
<td align="left" width="80%">'.number_format($pay_details['data']['amount']).' ZMW</td>
</tr>

<tr>
<td align="left" width="20%">Amount in words</td>
<td align="left" width="80%">'.ucwords(convertNumberToWord($pay_details['data']['amount'])).' Zambian Kwacha</td>
</tr>

<tr>
<td align="left" width="20%">In respect of</td>
<td align="left" width="80%">'.$personal_details[0]['name'].' Application Fee</td>
</tr>

<tr>
<td align="left" width="20%">Bill Reference</td>
<td align="left" width="80%">'.strtoupper($_SESSION['app_details'][0]['app_id']).'</td>
</tr>

<tr>
<td align="left" width="20%">Initiated At</td>
<td align="left" width="80%">'.strtoupper($pay_details['data']['initiatedAt']).'</td>
</tr>

<tr>
<td align="left" width="20%">Completed At</td>
<td align="left" width="80%">'.strtoupper($pay_details['data']['completedAt']).'</td>
</tr>

<tr>
<td align="left" width="20%">Issued By</td>
<td align="left" width="80%">Accounts Department</td>
</tr>

<tr>
<td align="left" width="20%" style="vertical-align: bottom"><br><br><br><br>Signature</td>
<td align="left" width="80%"><img height="60" src="assets/img/SIG.png"></td>
</tr>

</table>';

$pdf->writeHTMLCell(0, 0, '', '', $html, 0, 1, 0, true, '', true);

$style = array(
'position' => 'C',
'align' => 'C',
'stretch' => false,
'fitwidth' => true,
'cellfitalign' => '',
'border' => true,
'hpadding' => 'auto',
'vpadding' => 'auto',
'fgcolor' => array(0,0,0),
'bgcolor' => false,
'text' => true,
'font' => 'helvetica',
'fontsize' => 8,
'stretchtext' => 4
);

$pdf->Ln(20);

$pdf->write1DBarcode($_SESSION['app_details'][0]['app_id'], 'C128', '', '', '', 18, 0.4, $style, 'N');

$pdf->SetFont("helvetica", 'b', 10);

$pdf->Ln(4);


ob_end_clean();
$pdf->Output('Payment Receipt '.$_SESSION['app_details'][0]['app_id'].'.pdf');

}

}else{
http_response_code(403);
}
?>
