<?php
if (isset($is_authorized) && $is_authorized > 0 && $current_user[0]['level'] == "1" || $current_user[0]['level'] == "4") {

require 'classes/application_class.php';
require_once 'classes/intake_class.php';
$intake = new intake;
$application = new application;
$country_list = $application->get_countries();
$programme_types = $application->get_programme_types();
$intake_list = $intake->get_intakes();
$personal_details = $application->get_personal_details($_SESSION['app_details'][0]['app_id']);


?>
<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1.0">
<title><?php echo $env['name'].' - '.ucwords(str_replace("_"," ", $_GET['page'])).''; ?></title>
<meta name="description" content="<?php echo $env['alias']; ?>">
<base href="../">
<link rel="shortcut icon" href="assets/img/<?php echo $env['logo']; ?>">
<link rel="stylesheet" id="css-main" href="assets/css/dashmix.min-5.4.css">

<link rel="stylesheet" href="assets/js/plugins/bootstrap-datepicker/css/bootstrap-datepicker3.min.css">
<link rel="stylesheet" href="assets/js/plugins/flatpickr/flatpickr.min.css">
<link rel="stylesheet" href="assets/css/intlTelInput.min.css">
<link type="text/css" rel="stylesheet" href="assets/loader/waitMe.css">
<link rel="stylesheet" href="assets/js/plugins/select2/css/select2.min.css">
<link rel="stylesheet" href="whatsapp/venom-button.min.css" />
</head>
<body>
<div id="page-loader"><div class="loader-ring"></div></div>
<div id="page-container" class="page-container2 sidebar-o sidebar-light enable-page-overlay side-scroll page-header-fixed  page-header-dark">

<?php require_once 'includes/header.php'; ?>

<main id="main-container">
<div class="content">
<div class="d-md-flex justify-content-md-between align-items-md-center py-3 pt-md-3 pb-md-0 text-center text-md-start">
<div>
<h1 class="h3 mb-1">
<?php echo ucwords(str_replace("_"," ", $_GET['page'])); ?>
</h1>
</div>

</div>
</div>
<div class="content">
<div class="block block-rounded">

<div class="block-content block-content-full">
<?php
if (count($personal_details) < 1) {

?>
<form action="app/core/update_personal" autocomplete="OFF" method="POST" class="app_frm">

<div class="row">
<div class="col-lg-4 col-sm-12 mb-3">
<label class="form-label">Surname</label>
<input type="text" name="sname" required placeholder="Enter surname here" class="form-control ">
</div>
<div class="col-lg-4 col-sm-12 mb-3">
<label class="form-label">Forname(s)</label>
<input type="text" name="fname" required placeholder="Enter forname(s) here" class="form-control ">
</div>
<div class="col-lg-4 col-sm-12 mb-3">
<label class="form-label">NRC Number (For Zambian Citizens)</label>
<input type="text" name="nrc" class="js-masked-nrc form-control"  placeholder="XXXXXX/XX/X">

</div>
</div>

<div class="row">
<div class="col-lg-4 col-sm-12 mb-3">
<label class="form-label">Passport Number (For non Zambians)</label>
<input type="text" name="passport" placeholder="Enter passport number here" class="form-control ">
</div>


<div class="col-lg-4 col-sm-12 mb-3">
<label class="form-label">Birthday</label>
<input type="text" name="dob" required placeholder="Select Birthday" class="js-datepicker form-control" data-week-start="1" data-autoclose="true" data-today-highlight="true" data-date-format="yyyy-mm-dd">
</div>

<div class="col-lg-4 col-sm-12 mb-3">
<label class="form-label">Nationality</label>
<select name="nation" required class="form-control js-select2 form-select">
<option value="" selected disabled>Select Country</option>

<?php
foreach ($country_list as $country) {
?><option value="<?php echo $country['nicename']; ?>"><?php echo $country['nicename']; ?></option><?php
}
?>
</select>
</div>


</div>

<div class="row mb-4">


<div class="col-lg-4 col-sm-12 mb-3">
<label class="form-label">Mobile Phone</label>
<input type="text" id="phone" required  class="form-control " onchange="cp();" onkeyup="cp();" onkeydown="cp();">
<input type="hidden"  id="phone2"  name="phone" required>
</div>
<div class="col-lg-4 col-sm-12 mb-3">
<label class="form-label">Disability Status</label>
<select name="disabled" required class="form-control ">
<option value="" selected disabled>Select Option</option>
<option value="1">Yes</option>
<option value="0">No</option>
</select>
</div>
<div class="col-lg-4 col-sm-12 mb-3">
<label class="form-label">Nature of the disability</label>
<input type="text" name="nature" placeholder="Enter the nature of the disability" class="form-control ">
</div>

<div class="col-lg-6 col-sm-12 mb-2">
<label class="form-label">Which programme category are you applying for</label>
<select name="category" required class="form-control">
<option value="" selected disabled>Select Category</option>

<?php
foreach ($programme_types as $type) {
?><option value="<?php echo $type['id']; ?>"><?php echo $type['name']; ?></option><?php
}
?>
</select>
</div>


<div class="col-lg-6 col-sm-12 mb-2">
<label class="form-label">Which intake are you applying for</label>
<select name="intake" required class="form-control ">
<option value="" selected disabled>Select Intake</option>
<?php
foreach ($intake_list as $list) {
?><option value="<?php echo $list['id']; ?>"><?php echo $list['intake_name']; ?></option><?php
}
?>
</select>
</div>

</div>
<input type="hidden" name="app_id" value="<?php echo $_SESSION['app_details'][0]['app_id']; ?>">
<div class="mb-2">
<button type="submit" class="btn btn-primary">Save Changes</button>
</div>

</form>
<?php
}else{

?>
<div class="mb-1">
<label class="form-label">Surname</label>
<input type="text" readonly class="form-control-plaintext" value="<?php echo $personal_details[0]['surname']; ?>">
</div>
<div class="mb-1">
<label class="form-label" >Forname(s)</label>
<input type="text" readonly class="form-control-plaintext" value="<?php echo $personal_details[0]['fornames']; ?>">
</div>
<div class="mb-1">
<label class="form-label" >NRC Number</label>
<input type="text" readonly class="form-control-plaintext" value="<?php echo !empty($personal_details[0]['nrc']) ? $personal_details[0]['nrc'] : "Not Applicable"; ?>">
</div>
<div class="mb-1">
<label class="form-label" >Passport Number</label>
<input type="text" readonly class="form-control-plaintext" value="<?php echo !empty($personal_details[0]['passport_no']) ? $personal_details[0]['passport_no'] : "Not Applicable"; ?>">
</div>
<div class="mb-1">
<label class="form-label" >Birthday</label>
<input type="text" readonly class="form-control-plaintext" value="<?php echo date("F d, Y", strtotime($personal_details[0]['dob'])); ?>">
</div>
<div class="mb-1">
<label class="form-label" >Nationality</label>
<input type="text" readonly class="form-control-plaintext" value="<?php echo $personal_details[0]['nationality']; ?>">
</div>
<div class="mb-1">
<label class="form-label" >Mobile Number</label>
<input type="text" readonly class="form-control-plaintext" value="<?php echo $personal_details[0]['mobile_no']; ?>">
</div>
<div class="mb-1">
<label class="form-label" >Disability</label>
<input type="text" readonly class="form-control-plaintext" value="<?php echo $personal_details[0]['disability'] == "1" ? "Yes" : "No"; ?>">
</div>
<div class="mb-1">
<label class="form-label" >Nature of the disability</label>
<input type="text" readonly class="form-control-plaintext" value="<?php echo !empty($personal_details[0]['nature']) ? $personal_details[0]['nature'] : "Not Applicable"; ?>">
</div>

<div class="mb-1">
<label class="form-label" >Applying For</label>
<input type="text" readonly class="form-control-plaintext" value="<?php echo $personal_details[0]['name']; ?>">
</div>

<div class="mb-1">
<label class="form-label" >Academic Intake</label>

<?php
if (empty($personal_details[0]['intake_name'])) {

?>
<form action="app/core/update_inatake_application" autocomplete="OFF" method="POST" class="app_frm">

<div class="row mb-4">

<div class="col-lg-12 col-sm-12 mb-2">
<label class="form-label">You have not select intake, please select one</label>
<select name="intake" required class="form-control ">
<option value="" selected disabled>Select Intake</option>
<?php
foreach ($intake_list as $list) {
?><option value="<?php echo $list['id']; ?>"><?php echo $list['intake_name']; ?></option><?php
}
?>
</select>
</div>

</div>
<input type="hidden" name="app_id" value="<?php echo $_SESSION['app_details'][0]['app_id']; ?>">
<div class="mb-2">
<button type="submit" class="btn btn-primary">Save Changes</button>
</div>

</form>

<?php
}else{
?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo $personal_details[0]['intake_name']; ?>">
<?php
}
?>

</div>

<center>
<div class="btn-group btn-group-lg mt-4" role="group" aria-label="Large Horizontal Alternate Primary">
<a type="button" class="btn btn-alt-secondary disabled">
<i class="fa fa-arrow-left"></i> Previous
</a>
<button type="button" class="btn btn-alt-secondary disabled">
|
</button>
<a href="app?page=application_fee" class="btn btn-alt-secondary">
<i class="fa fa-arrow-right"></i> Next
</a>
</div>
</center>
<?php
}
?>


</div>



</div>


</div><div id="whatsappButton"></div>
</main>

</div>
<script src="assets/js/gru_oas.js"></script>
<script src="assets/js/lib/jquery.min.js"></script>
<script src="assets/loader/waitMe.js"></script>
<script src="assets/js/custom.js"></script>
<script src="assets/js/sweetalert.min.js"></script>
<script src="assets/js/plugins/bootstrap-datepicker/js/bootstrap-datepicker.min.js"></script>
<script src="assets/js/plugins/jquery.maskedinput/jquery.maskedinput.min.js"></script>
<script src="assets/js/plugins/select2/js/select2.full.min.js"></script>
<script src="assets/js/plugins/flatpickr/flatpickr.min.js"></script>
<script src="assets/js/intlTelInput-jquery.min.js"></script>
<script src="whatsapp/venom-button.min.js"></script>
<script>
$('#whatsappButton').venomButton({
phone: '260951653600',
popupMessage: 'Hello, how can we help you?',
message: "I'd like to know more about Gideon Roberty University",
showPopup: true,
position: "right",
linkButton: false,
headerTitle: 'Live Chat Support 24/7',
headerColor: '#25d366',
backgroundColor: '#25d366',
});
</script>
<script>
GRU.helpersOnLoad(['js-flatpickr', 'jq-datepicker', 'jq-masked-inputs', 'jq-select2']);

$(function () {
$("#phone").intlTelInput({
initialCountry : "ZM",
separateDialCode: !0,
utilsScript: "assets/js/utils.js"
});
})

function cp() {
$("#phone2").val($("#phone").intlTelInput("getNumber"));
}
</script>
<?php $db->kill_conn(); require_once('assets/includes/check_reply.php'); ?>
</body>
</html>
<?php
}else{
http_response_code(403);
}
?>
