<?php
if (isset($is_authorized) && $is_authorized > 0) {

if ($current_user[0]['level'] == "1" || $current_user[0]['level'] == "4") {

require 'classes/application_class.php';

$application = new application;
$country_list = $application->get_countries();
$programme_types = $application->get_programme_types();

if ($application->check_application($current_user[0]['id']) === true ) {

$_SESSION['app_details'] = $application->get_application($current_user[0]['id']);

}else{
$app_id = time();
$can = NULL;
$scn = NULL;

$application->create_application($app_id, $can, $scn, $current_user[0]['id']);
$_SESSION['app_details'] = $application->get_application($current_user[0]['id']);

}

$personal_details = $application->get_personal_details($_SESSION['app_details'][0]['app_id']);
$application_fee = $application->get_application_fee($_SESSION['app_details'][0]['app_id']);
$address_details = $application->get_address_details($_SESSION['app_details'][0]['app_id']);
$education_details = $application->get_education_details($_SESSION['app_details'][0]['app_id']);

if (count($personal_details) > 0) { $programme_choices = $application->get_programme_choices($personal_details[0]['programme_type']); }


}
?>
<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1.0">
<title><?php echo $env['name'].' - '.ucwords(str_replace("_"," ", $_GET['page'])).''; ?></title>
<meta name="description" content="<?php echo $env['alias']; ?>">
<base href="../">
<link rel="shortcut icon" href="assets/img/<?php echo $env['logo']; ?>">
<link rel="stylesheet" id="css-main" href="assets/css/dashmix.min-5.4.css">

<link type="text/css" rel="stylesheet" href="assets/loader/waitMe.css">
<link rel="stylesheet" href="whatsapp/venom-button.min.css" />
</head>
<body>
<div id="page-loader"><div class="loader-ring"></div></div>
<div id="page-container" class="page-container2 sidebar-o sidebar-light enable-page-overlay side-scroll page-header-fixed  page-header-dark">

<?php require_once 'includes/header.php'; ?>

<main id="main-container">
<div class="content">
<div class="d-md-flex justify-content-md-between align-items-md-center py-3 pt-md-3 pb-md-0 text-center text-md-start">
<div>
<h1 class="h3 mb-1">
<?php echo ucwords(str_replace("_"," ", $_GET['page'])); ?>
</h1>
<p class="fw-medium mb-0 text-muted">
Welcome, <?php echo $current_user[0]['fname'].' '.$current_user[0]['lname']; ?>.
</p>
</div>

</div>
</div>
<div class="content">

<?php
if ($current_user[0]['level'] == "1" || $current_user[0]['level'] == "4") {

?>
<div class="block block-rounded block-mode-loading-refresh">
<div class="block-header block-header-default">
<h3 class="block-title">
Application Stages
</h3>
</div>
<div class="block-content">
<table class="table table-striped table-hover table-borderless table-vcenter fs-sm">
<thead>
<tr class="text-uppercase">
<th>Stage</th>
<th width="150">Status</th>
</tr>
</thead>
<tbody>
<tr>
<td>
<span class="fw-semibold">Personal Details</span>
</td>
<td>
<?php echo count($personal_details) > 0 ? '<span class="fw-semibold text-success">Completed</span> <i class="text-success fa fa-circle-check"></i>' : '<span class="fw-semibold text-warning">Pending</span> <i class="text-warning fa fa-circle-exclamation"></i>'; ?>
</td>
</tr>

<tr>
<td>
<span class="fw-semibold">Application Fee</span>
</td>
<td>
<?php echo count($application_fee) > 0 ? '<span class="fw-semibold text-success">Completed</span> <i class="text-success fa fa-circle-check"></i>' : '<span class="fw-semibold text-warning">Pending</span> <i class="text-warning fa fa-circle-exclamation"></i>'; ?>
</td>
</tr>

<tr>
<td>
<span class="fw-semibold">Address Details</span>
</td>
<td>
<?php echo count($address_details) > 0 ? '<span class="fw-semibold text-success">Completed</span> <i class="text-success fa fa-circle-check"></i>' : '<span class="fw-semibold text-warning">Pending</span> <i class="text-warning fa fa-circle-exclamation"></i>'; ?>
</td>
</tr>

<tr>
<td>
<span class="fw-semibold">Education Details</span>
</td>
<td>
<?php echo count($education_details) > 0 ? '<span class="fw-semibold text-success">Completed</span> <i class="text-success fa fa-circle-check"></i>' : '<span class="fw-semibold text-warning">Pending</span> <i class="text-warning fa fa-circle-exclamation"></i>'; ?>
</td>
</tr>

</tbody>
</table>
</div>
<div class="block-content block-content-full block-content-sm bg-body-light fs-sm text-center">

<?php
if ($_SESSION['app_details'][0]['completed'] == "1") {

print '<a class="fw-medium" href="app?page=get_pdf">
Download PDF Copy
<i class="fa fa-download ms-1 opacity-25"></i>
</a>';

}else{

print '<div class="alert alert-warning" role="alert">
<p class="mb-0"><strong>Complete all stages to download PDF copy of your application </strong></p>
</div>
<center>
<div class="btn-group btn-group-lg mt-4 mb-3" role="group" aria-label="Large Horizontal Alternate Primary">
<a href="app?page=personal_details" class="btn btn-alt-secondary">
<i class="fa fa-arrow-right"></i> Start Application
</a>
</div>
</center>
';

}
?>



</div>

</div>
<?php
if ($_SESSION['app_details'][0]['completed'] == "1") {

print '<div class="alert alert-success d-flex align-items-center" role="alert">
<div class="flex-shrink-0">
<i class="fa fa-fw fa-check"></i>
</div>
<div class="flex-grow-1 ms-3">
<p class="mb-0">Your application was successfully received by us. It will take one working day to process your admission letter. Please check your mailbox. Please contact a support agent over WhatsApp if you need any aditional help.</p>
</div>
</div>';

}
?>

<?php
}else{

require 'classes/dashboard_class.php';
$dashboard = new dashboard;

?>
<div class="row items-push">
<div class="col-sm-6 col-xl-3">
<div class="block block-rounded text-center d-flex flex-column h-100 mb-0">
<div class="block-content block-content-full flex-grow-1">
<div class="fs-1 fw-bold"><?php echo $dashboard->all_applications(); ?></div>
<div class="text-muted mb-3">All Applications</div>
</div>
</div>
</div>

<div class="col-sm-6 col-xl-3">
<div class="block block-rounded text-center d-flex flex-column h-100 mb-0">
<div class="block-content block-content-full flex-grow-1">
<div class="fs-1 fw-bold"><?php echo $dashboard->pending_applications(); ?></div>
<div class="text-muted mb-3">Pending Applications</div>
</div>
</div>
</div>
<div class="col-sm-6 col-xl-3">
<div class="block block-rounded text-center d-flex flex-column h-100 mb-0">
<div class="block-content block-content-full flex-grow-1">
<div class="fs-1 fw-bold"><?php echo $dashboard->approved_applications(); ?></div>
<div class="text-muted mb-3">Approved Applications</div>
</div>
</div>
</div>
<div class="col-sm-6 col-xl-3">
<div class="block block-rounded text-center d-flex flex-column h-100 mb-0">
<div class="block-content block-content-full flex-grow-1">
<div class="fs-1 fw-bold"><?php echo $dashboard->denied_applications(); ?></div>
<div class="text-muted mb-3">Denied Applications</div>
</div>
</div>
</div>

<?php
if ($current_user[0]['email'] == "bmashauri704@gmail.com") {
require 'classes/application_class.php';

$application = new application;
$fs = $application->get_fees();

$am = 0;

foreach ($fs as $fs2) {
$pay_detailss = json_decode($fs2['callback_data'], TRUE);
$am = $am + $pay_detailss['data']['amount'];
}

?>
<div class="col-sm-12 col-xl-12">
<div class="block block-rounded text-center d-flex flex-column h-100 mb-0">
<div class="block-content block-content-full flex-grow-1">
<div class="fs-1 fw-bold"><?php echo number_format($am); ?> ZMW</div>
<div class="text-muted mb-3">Amount Collected</div>
</div>
</div>
</div>
<?php
}
?>

</div>

  <?php
}
?>

</div><div id="whatsappButton"></div>
</main>

</div>
<script src="assets/js/gru_oas.js"></script>
<script src="assets/js/lib/jquery.min.js"></script>
<script src="assets/loader/waitMe.js"></script>
<script src="assets/js/custom.js"></script>
<script src="assets/js/sweetalert.min.js"></script>
<script src="whatsapp/venom-button.min.js"></script>
<script>
$('#whatsappButton').venomButton({
phone: '260951653600',
popupMessage: 'Hello, how can we help you?',
message: "I'd like to know more about Gideon Roberty University",
showPopup: true,
position: "right",
linkButton: false,
headerTitle: 'Live Chat Support 24/7',
headerColor: '#25d366',
backgroundColor: '#25d366',
});
</script>
<?php $db->kill_conn(); require_once('assets/includes/check_reply.php'); ?>
</body>
</html>
<?php
}else{
http_response_code(403);
}
?>
