<?php
session_start();
chdir('../../');
require 'classes/database_class.php';
require 'classes/util.php';
require 'classes/users_class.php';
require 'classes/session_class.php';
require 'classes/accounts_class.php';


$util = new util;
$users = new users;
$session = new session;
$accounts = new accounts;
$env = $util->env();

if ($_SERVER['REQUEST_METHOD'] === 'POST' && $_POST['csrf_token'] == $_SESSION['csrf_token']) {

$fname = $util->sanitize(ucwords($_POST['fname']));
$lname = $util->sanitize(ucwords($_POST['lname']));
$email = $util->sanitize($_POST['email']);
$gender = $util->sanitize(ucwords($_POST['gender']));

$current_user = $users->auth_user($_SESSION['logged_account'][0]['email']);


if ($users->update_user($fname, $lname, $gender, $email, $current_user[0]['hashed_pw'], $current_user[0]['id']) === true) {
$util->setMessage("success", "Account updated successfully");
header("location:../?page=account");

}else{

$util->setMessage("error", "Something went wrong");
header("location:../?page=account");

}



}else{
http_response_code(403);
}
?>
