<?php
session_start();
chdir('../../');
require 'classes/database_class.php';
require 'classes/util.php';
require 'classes/application_class.php';
require 'classes/users_class.php';
require 'classes/session_class.php';
require 'classes/accounts_class.php';

$util = new util;
$application = new application;
$users = new users;
$session = new session;
$accounts = new accounts;
$env = $util->env();

$amount = $_SESSION['current_fee'];
$red = $_SESSION['domain'];
$current_user = $users->auth_user($_SESSION['logged_account'][0]['email']);
$personal_details = $application->get_personal_details($_SESSION['app_details'][0]['app_id']);
$curl = curl_init();

curl_setopt_array($curl, [
CURLOPT_URL => "https://api.flutterwave.com/v3/payments",
CURLOPT_RETURNTRANSFER => true,
CURLOPT_ENCODING => "",
CURLOPT_MAXREDIRS => 10,
CURLOPT_TIMEOUT => 30,
CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
CURLOPT_CUSTOMREQUEST => "POST",
CURLOPT_POSTFIELDS => json_encode([
'amount' => $amount,
'tx_ref' => 'FW_'.time().'',
'currency' => 'ZMW',
'redirect_url' => $red,
'customer' => [
'email' => $current_user[0]['email'],
'phone_number' => $personal_details[0]['mobile_no'],
'name' => $current_user[0]['fname']
],
'customizations' => [
'title' => 'Application Fee Payment',
],
'configuration' => [
'session_duration' => 30
],
'payment_options' => 'card, mobile_money_zambia',
]),
CURLOPT_HTTPHEADER => [
"Authorization: Bearer FLWSECK-e9718afffe96611d0d20637640ca7757-1970829baefvt-X",
"Content-Type: application/json",
"accept: application/json"
],
]);

$response = curl_exec($curl);
$err = curl_error($curl);


curl_close($curl);

if ($err) {
echo "cURL Error #:" . $err;
} else {

$res = json_decode($response);
if($res->status == 'success')
{
$link = $res->data->link;
header('Location: '.$link);
}
else
{
echo 'We can not process your payment';
}

}




?>
