<?php
session_start();
chdir('../../');
require 'classes/database_class.php';
require 'classes/util.php';
require 'classes/users_class.php';
require 'classes/session_class.php';
require 'classes/accounts_class.php';


$util = new util;
$users = new users;
$session = new session;
$accounts = new accounts;
$env = $util->env();

if ($_SERVER['REQUEST_METHOD'] === 'POST' && $_POST['csrf_token'] == $_SESSION['csrf_token']) {

$fname = $util->sanitize(ucwords($_POST['fname']));
$lname = $util->sanitize(ucwords($_POST['lname']));
$gender = $util->sanitize($_POST['gender']);
$email = $util->sanitize($_POST['email']);
$login_password = $_POST['password'];
$login_password_hashed = password_hash($login_password, PASSWORD_BCRYPT);
$level = 4;

if ($users->valid_email2($email) === true) {

if ($users->add_user($fname, $lname, $gender, $email, $login_password_hashed, $level)) {

$util->setMessage("success", "Test account created successfully");
header("location:../?page=test_accounts");

}else{
$util->setMessage("error", "An error occured");
header("location:../?page=test_accounts");
}

}else{

$util->setMessage("error", "Email is already registered");
header("location:../?page=test_accounts");

}

}else{
http_response_code(403);
}
?>
