<?php
require_once 'autoload.php';

$uni = new university_controller;
$nationality = new nationality_controller;
$programmes = new programmes_controller;
$exam_types = new exam_types_controller;
$exam_sessions = new exam_sessions_controller;

$info = $uni->index();
$nations = $nationality->index();
$programme_list = $programmes->index();
$type_list = $exam_types->index();
$session_list = $exam_sessions->index();
?>
<!doctype html>
<html lang="en" class="remember-theme">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1.0">
<title>SERS - Students Examinations Registration System</title>
<meta name="description" content="Students Examinations Registration System">
<meta name="author" content="Bwire Mashauri">
<meta name="robots" content="index, follow">
<link rel="shortcut icon" href="storage/images/misc/<?php echo $info['icon']; ?>">
<link rel="stylesheet" href="assets/js/plugins/bootstrap-datepicker/css/bootstrap-datepicker3.min.css">
<link rel="stylesheet" href="assets/css/intlTelInput.min.css">
<link rel="stylesheet" href="whatsapp/venom-button.min.css" />
<link rel="stylesheet" href="assets/js/plugins/select2/css/select2.min.css">
<link rel="stylesheet" type="text/css" href="dist/css/MultiStep.min.css">
<link rel="stylesheet" type="text/css" href="dist/css/MultiStep-theme.min.css">
<link rel="stylesheet" id="css-main" href="assets/css/main.css">
<?php echo $info['theme'] !== '0' ? '<link type="text/css" rel="stylesheet" id="css-theme" href="assets/css/themes/'.$info['theme'].'.css">' : '' ; ?>
<link href="assets/js/plugins/sweetalert2/sweetalert2.min.css" rel="stylesheet" type="text/css" />
</head>
<body>
<div id="page-loader" class="show"></div>

<div id="page-container">

<main id="main-container">

<div class="bg-image" >

<div class="row g-0 justify-content-center bg-primary-dark-op">
<div class="hero-static col-sm-8 col-md-8 col-l-8 col-xl-8 d-flex align-items-center p-2 px-sm-0">
<div class="block block-transparent block-rounded w-100 mb-0 overflow-hidden">
<div class="block-content block-content-full px-lg-5 px-xl-6 py-4 py-md-5 py-lg-6 bg-body-extra-light">

<div class="text-center">
<img src="storage/images/misc/<?php echo $info['logo']; ?>" height="130" alt="School Logo">
<h5 class="font-size-10 mt-3">Students Examinations Registration System</h5>
<p class="text-muted login_paragraph">Kindly follow the steps below to register for an exam.</p>
</div>

<div class="block-content block-content-full space-y-3">
<div class="alert alert-info">Already registered? click <a href="javascript:void(0);" data-bs-toggle="modal" data-bs-target="#modal-docket" data-bs-keyboard="false" data-bs-backdrop="static">HERE</a> to download exam docket</div>
<div class="block block-rounded">
<form id="regForm" action="routes/start_application" autocomplete="off" method="post"class="app_frm" enctype="multipart/form-data">
<ul class="nav nav-tabs nav-tabs-block" role="tablist">
<li class="nav-item" role="presentation">
<button type="button" class="nav-link active" id="btabs-static-personal-tab" data-bs-toggle="tab" data-bs-target="#btabs-static-personal" role="tab" aria-controls="btabs-static-personal" aria-selected="true">Personal Information</button>
</li>
<li class="nav-item" role="presentation">
<button type="button" class="nav-link" id="btabs-static-education-tab" data-bs-toggle="tab" data-bs-target="#btabs-static-education" role="tab" aria-controls="btabs-static-education" aria-selected="false" tabindex="-1">Education Details</button>
</li>
</ul>
<div class="block-content tab-content">
<div class="tab-pane fade active show" id="btabs-static-personal" role="tabpanel" aria-labelledby="btabs-static-personal-tab" tabindex="0">

<div class="row mb-4">
<div class="col-xl-3 col-l-3 col-md-6 col-sm-12 mb-2">
<label>First Name</label>
<input name="first_name" required type="text" class="form-control" placeholder="Enter first name">
</div>
<div class="col-xl-3 col-l-3 col-md-6 col-sm-12 mb-2">
<label>Last Name</label>
<input name="last_name" required type="text" class="form-control" placeholder="Enter last name">
</div>
<div class="col-xl-3 col-l-3 col-md-6 col-sm-12 mb-2">
<label>Birthday</label>
<input name="dob" readonly required type="text" class="form-control js-datepicker" placeholder="Select Birthday">
</div>
<div class="col-xl-3 col-l-3 col-md-6 col-sm-12 mb-2">
<label>NRC (For Zambians)</label>
<input name="nrc" type="text" class="form-control js-masked-nrc" placeholder="Enter NRC">
</div>

<div class="col-xl-4 col-l-4 col-md-6 col-sm-12 mb-2">
<label class="form-label">Passport Number (For non Zambians)</label>
<input type="text" name="passport" placeholder="Enter passport number here" class="form-control ">
</div>


<div class="col-xl-4 col-l-4 col-md-6 col-sm-12 mb-2">
<label>Nationality</label>
<select name="nationality" required  class="form-control select_country">
<option value="" selected disabled>Select Nationality</option>
<?php
foreach ($nations as $key => $value) {
?><option value="<?php echo $value['name']; ?>"><?php echo $value['name']; ?></option><?php
}
?>
</select>
</div>
<div class="col-xl-4 col-l-4 col-md-6 col-sm-12 mb-2">
<label>City / Town</label>
<input name="city" required type="text" class="form-control" placeholder="Enter city / town">
</div>
<div class="col-xl-6 col-l-6 col-md-6 col-sm-12 mb-2">
<label>Birth Place</label>
<input name="birthplace" required type="text" class="form-control" placeholder="Enter birthplace">
</div>
<div class="col-xl-6 col-l-6 col-md-6 col-sm-12 mb-2">
<label>Email Address</label>
<input name="email_address" required type="text" class="form-control" placeholder="Enter email address">
</div>

<div class="col-xl-6 col-l-6 col-md-12 col-sm-12 mb-2">
<label>Mobile Phone</label>
<input name="telephone" required type="text" class="form-control" placeholder="Enter mobile phone">
</div>
<div class="col-xl-6 col-l-6 col-md-12 col-sm-12 mb-2">
<label>WhatsApp Number</label>
<input name="whatsapp_no" required type="text" class="form-control" placeholder="Enter whatsapp number">
</div>


<div class="col-xl-6 col-l-6 col-md-12 col-sm-12 mb-2">
<label>Student Number</label>
<input name="student_number" required type="text" class="form-control" placeholder="Enter your student number">
</div>
<div class="col-xl-6 col-l-6 col-md-12 col-sm-12 mb-2">
<label>Image (Passport Size)</label>
<input name="file" required type="file" class="form-control">
</div>

</div>
<div class="mt-4 text-end">
<button type="button" class="btn btn-primary" id="goEducationTab">Next →</button>
</div>
</div>
<div class="tab-pane fade" id="btabs-static-education" role="tabpanel" aria-labelledby="btabs-static-education-tab" tabindex="0">

<div class="row mb-4">

<div class="col-xl-12 col-l-12 col-md-12 col-sm-12 mb-2">
<label>Academic Programme</label>
<select name="programme_id" required  id="programme_id" class="form-control select_programme">
<option value="" selected disabled>Select Programme</option>
<?php
foreach ($programme_list as $key => $value) {
?><option value="<?php echo $value['id']; ?>"><?php echo $value['name']; ?></option><?php
}
?>
</select>
</div>
<div class="col-xl-12 col-l-12 col-md-12 col-sm-12 mb-2">
<label>Academic Courses</label>
<select name="courses[]" id="courses" required  class="form-control select_course" multiple>

</select>
</div>
<div class="col-xl-6 col-l-6 col-md-6 col-sm-12 mb-2">
<label>Examination Type</label>
<select name="exam_type" id="exam_type" required  class="form-control">
<option value="" selected disabled>Select Type</option>
<?php
foreach ($type_list as $key => $value) {
?><option value="<?php echo $value['id']; ?>"><?php echo $value['name']; ?></option><?php
}
?>
</select>
</div>
<div class="col-xl-6 col-l-6 col-md-6 col-sm-12 mb-2">
<label>Session</label>
<select name="session" id="session" required  class="form-control">
<option value="" selected disabled>Select Type</option>
<?php
foreach ($session_list as $key => $value) {
?><option value="<?php echo $value['id']; ?>"><?php echo $value['name']; ?></option><?php
}
?>
</select>
</div>


</div>
<div class="mt-4 d-flex justify-content-between">
<button type="button" class="btn btn-primary" id="goPersonalTab">← Previous</button>
<button type="submit" class="btn btn-success">Submit</button>
</div>
</div>
<?= $waf->csrf_field('start_application.php', 1800) ?>
</div>
</form>
</div>
</div>
</div>
</div>
</div>
</div>
</div>
</main>




<div class="modal fade" id="modal-docket" role="dialog" aria-labelledby="modal-docket"  data-bs-keyboard="false" data-bs-backdrop="static">
<div class="modal-dialog" role="document">
<div class="modal-content">
<div class="block block-rounded shadow-none mb-0">
<div class="block-header block-header-default">
<h4 class="block-title">Download Exam Docket</h4>
</div>
<div class="block-content" id="docket_response">
<div class="mb-2">
<label class="form-label">Student Number</label>
<input type="text" required class="form-control" id="student_number" autocomplete="off" placeholder="Enter your student number">
</div>
<div class="mb-4">
<button type="button" class="btn btn-primary search_btn">Search</button>
<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
</div>
</div>
</div>
</div>
</div>
</div>

</div>
<div id="whatsapp_chat"></div>
<script src="assets/js/main.js"></script>
<script src="assets/js/lib/jquery.min.js"></script>
<script src="assets/js/forms.js"></script>
<script src="assets/js/plugins/jquery-validation/jquery.validate.min.js"></script>
<script src="assets/js/plugins/bootstrap-datepicker/js/bootstrap-datepicker.min.js"></script>
<script src="assets/js/plugins/select2/js/select2.full.min.js"></script>
<script src="assets/js/validation/application.js"></script>
<script src="assets/js/plugins/sweetalert2/sweetalert2.min.js"></script>
<script src="whatsapp/venom-button.min.js"></script>
<script src="assets/js/plugins/jquery.maskedinput/jquery.maskedinput.min.js"></script>
<script src="assets/js/plugins/sweetalert2/sweetalert2.min.js"></script>
<script type="text/javascript" src="dist/js/MultiStep.min.js"></script>
<script nonce="<?php echo $wafConfig['nonce']; ?>">
$(document).ready(function() {

$(".select_country, .select_programme, .select_course").select2({width: '100%'});

$(".js-masked-nrc").mask("999999/99/9");

$(".js-datepicker").datepicker({
autoclose: true,
todayHighlight: true,
endDate: new Date(),
format: "yyyy-mm-dd",
orientation: "bottom"
});



});

$("#goEducationTab").on("click", function() {
new bootstrap.Tab(document.querySelector('#btabs-static-education-tab')).show();
});
$("#goPersonalTab").on("click", function() {
new bootstrap.Tab(document.querySelector('#btabs-static-personal-tab')).show();
});
SERS.helpersOnLoad(['jq-datepicker']);


$('#whatsapp_chat').venomButton({
phone: '260977462120',
popupMessage: 'Hello, how can we help you?',
message: "",
showPopup: true,
position: "right",
linkButton: false,
headerTitle: 'Live Chat Support 24/7',
headerColor: '#25d366',
backgroundColor: '#25d366',
});
</script>

<?php require_once('includes/check_reply.php'); ?>
</body>
</html>
