<?php
chdir('../');
require_once 'autoload.php';
$admin = new admin_controller;
$session = new session;
$dashboard = new dashboard_controller;
$uni = new university_controller;
$info = $uni->index();

date_default_timezone_set($info['timezone']);

$page = $utility->get_page();

require_once 'includes/session_validator.php';

if (!empty($is_authenticated) && $is_authenticated == 1) {

$payments = $dashboard->payments();

?>
<!doctype html>
<html lang="en" class="remember-theme">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1.0">
<title>SERS - Dashboard</title>
<meta name="description" content="Students Examinations Registration System">
<meta name="author" content="Bwire Mashauri">
<meta name="robots" content="index, follow">
<base href="../">
<link rel="shortcut icon" href="storage/images/misc/<?php echo $info['icon']; ?>">
<link rel="stylesheet" id="css-main" href="assets/css/main.css">
<?php echo $info['theme'] !== '0' ? '<link type="text/css" rel="stylesheet" id="css-theme" href="assets/css/themes/'.$info['theme'].'.css">' : '' ; ?>
<link href="assets/js/plugins/sweetalert2/sweetalert2.min.css" rel="stylesheet" type="text/css" />
</head>
<body>
<div id="page-loader" class="show"></div>

<div id="page-container" class="sidebar-o <?php echo $info['sidebar'];?> enable-page-overlay side-scroll page-header-fixed page-footer-fixed">

<nav id="sidebar" aria-label="Main Navigation">
<div class="bg-header-dark">
<div class="content-header bg-white-5">
<a class="fw-semibold text-white tracking-wide" href="./app/dashboard">
<span class="smini-hidden desc">
Students Examinations Registration System
</span>
</a>
</div>
</div>
<div class="js-sidebar-scroll">
<div class="content-side">

<div class="text-center"><img class="mb-3 center_img" src="storage/images/misc/<?php echo $info['logo']; ?>" height="140" alt="School Logo"></div>

<ul class="nav-main">

<?php require_once 'includes/header.php'; ?>

</ul>
</div>
</div>
</nav>
<header id="page-header">
<div class="content-header">
<div class="space-x-1">
<button type="button" class="btn btn-alt-secondary" data-toggle="layout" data-action="sidebar_toggle">
<i class="fa fa-fw fa-bars"></i>
</button>
</div>
<div class="space-x-1">
<div class="dropdown d-inline-block">
<button type="button" class="btn btn-alt-secondary" id="page-header-user-dropdown" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
<i class="fa fa-fw fa-user d-sm-none"></i>
<span class="d-none d-sm-inline-block"><?php echo $profile['first_name'].' '.$profile['last_name']; ?></span>
<i class="fa fa-fw fa-angle-down opacity-50 ms-1 d-none d-sm-inline-block"></i>
</button>
<div class="dropdown-menu dropdown-menu-end p-0" aria-labelledby="page-header-user-dropdown">
<div class="bg-primary-dark rounded-top fw-semibold text-white text-center p-3">
My Profile
</div>
<div class="p-2">
<a class="dropdown-item" href="app/account">
<i class="far fa-fw fa-user me-1"></i> Account Settings
</a>
<div role="separator" class="dropdown-divider"></div>
<a class="dropdown-item" href="app/logout">
<i class="far fa-fw fa-arrow-alt-circle-left me-1"></i> Log Out
</a>
</div>
</div>
</div>
</div>
</div>
</header>
<main id="main-container">
<div class="content">
<div class="row items-push">

<div class="col-sm-6 col-xl-3">
<div class="block block-rounded text-center d-flex flex-column h-100 mb-0">
<div class="block-content block-content-full flex-grow-1">
<div class="item item-circle bg-body-light mx-auto">
<i class="fa fa-2x fa-book-open-reader text-primary"></i>
</div>
<div class="fs-5 fw-bold"><?php echo number_format($dashboard->programmes()[0]['total_programmes']); ?></div>
<div class="text-muted mb-3">ACADEMIC PROGRAMMES</div>
</div>
</div>
</div>

<div class="col-sm-6 col-xl-3">
<div class="block block-rounded text-center d-flex flex-column h-100 mb-0">
<div class="block-content block-content-full flex-grow-1">
<div class="item item-circle bg-body-light mx-auto">
<i class="fa fa-2x fa-book text-primary"></i>
</div>
<div class="fs-5 fw-bold"><?php echo number_format($dashboard->courses()[0]['total_courses']); ?></div>
<div class="text-muted mb-3">ACADEMIC COURSES</div>
</div>
</div>
</div>

<div class="col-sm-6 col-xl-3">
<div class="block block-rounded text-center d-flex flex-column h-100 mb-0">
<div class="block-content block-content-full flex-grow-1">
<div class="item item-circle bg-body-light mx-auto">
<i class="fa fa-2x fa-bars-progress text-primary"></i>
</div>
<div class="fs-5 fw-bold"><?php echo number_format($dashboard->sessions()[0]['total_sessions']); ?></div>
<div class="text-muted mb-3">EXAM SESSIONS</div>
</div>
</div>
</div>

<div class="col-sm-6 col-xl-3">
<div class="block block-rounded text-center d-flex flex-column h-100 mb-0">
<div class="block-content block-content-full flex-grow-1">
<div class="item item-circle bg-body-light mx-auto">
<i class="fa fa-2x fa-box-archive text-primary"></i>
</div>
<div class="fs-5 fw-bold"><?php echo number_format($dashboard->types()[0]['total_types']); ?></div>
<div class="text-muted mb-3">EXAM TYPES</div>
</div>
</div>
</div>


<div class="col-sm-6 col-xl-3">
<div class="block block-rounded text-center d-flex flex-column h-100 mb-0">
<div class="block-content block-content-full flex-grow-1">
<div class="item item-circle bg-body-light mx-auto">
<i class="fa fa-2x fa-money-bill-1-wave text-primary"></i>
</div>
<div class="fs-5 fw-bold"><?php echo !empty($payments[0]['total_today']) ? number_format($payments[0]['total_today']).$info['currency_name'] : '0'.$info['currency_name']; ?></div>
<div class="text-muted mb-3">FEES COLLECTED TODAY</div>
</div>
</div>
</div>

<div class="col-sm-6 col-xl-3">
<div class="block block-rounded text-center d-flex flex-column h-100 mb-0">
<div class="block-content block-content-full flex-grow-1">
<div class="item item-circle bg-body-light mx-auto">
<i class="fa fa-2x fa-money-bill-1-wave text-primary"></i>
</div>
<div class="fs-5 fw-bold"><?php echo !empty($payments[0]['total_this_week']) ? number_format($payments[0]['total_this_week']).$info['currency_name'] : '0'.$info['currency_name']; ?></div>
<div class="text-muted mb-3">FEES COLLECTED THIS WEEK</div>
</div>
</div>
</div>

<div class="col-sm-6 col-xl-3">
<div class="block block-rounded text-center d-flex flex-column h-100 mb-0">
<div class="block-content block-content-full flex-grow-1">
<div class="item item-circle bg-body-light mx-auto">
<i class="fa fa-2x fa-money-bill-1-wave text-primary"></i>
</div>
<div class="fs-5 fw-bold"><?php echo !empty($payments[0]['total_this_month']) ? number_format($payments[0]['total_this_month']).$info['currency_name'] : '0'.$info['currency_name']; ?></div>
<div class="text-muted mb-3">FEES COLLECTED THIS MONTH</div>
</div>
</div>
</div>

<div class="col-sm-6 col-xl-3">
<div class="block block-rounded text-center d-flex flex-column h-100 mb-0">
<div class="block-content block-content-full flex-grow-1">
<div class="item item-circle bg-body-light mx-auto">
<i class="fa fa-2x fa-money-bill-1-wave text-primary"></i>
</div>
<div class="fs-5 fw-bold"><?php echo !empty($payments[0]['total_all_time']) ? number_format($payments[0]['total_all_time']).$info['currency_name'] : '0'.$info['currency_name']; ?></div>
<div class="text-muted mb-3">FEES COLLECTED ALL TIME</div>
</div>
</div>
</div>

</div>
</div>
</main>
<footer id="page-footer" class="bg-body-light">
<div class="content py-0">
<div class="row fs-sm">
<div class="col-sm-6 order-sm-2 mb-1 mb-sm-0 text-center text-sm-end">
<?php echo $info['name']; ?>
</div>
<div class="col-sm-6 order-sm-1 text-center text-sm-start">
<a class="fw-semibold">Students Examinations Registration System</a> &copy; <span data-toggle="year-copy"></span>
</div>
</div>
</div>
</footer>
</div>
<script src="assets/js/main.js"></script>
<script src="assets/js/lib/jquery.min.js"></script>
<script src="assets/js/forms.js"></script>
</body>
</html>
<?php

}else{

header("location:../");

}
?>
