<?php
session_start();
require 'classes/database_class.php';
require 'classes/util.php';
require 'classes/application_class.php';
require_once 'classes/intake_class.php';

$intake = new intake;
$application = new application;
$country_list = $application->get_countries();
$intake_list = $intake->get_intakes();
$programme_types = $application->get_programme_types();

$db = new database;
$util = new util;
$env = $util->env();

if(!isset($_SESSION["current_folder"])) {

$_SESSION["current_folder"] = strtoupper('FOLDER_'.time());

$unlink_dir = 'uploads/'.$_SESSION["current_folder"].'/';

}else{

$unlink_dir = 'uploads/'.$_SESSION["current_folder"].'/';

array_map('unlink', array_filter((array) glob("$unlink_dir*")));

}
?>
<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1.0">
<title><?php echo $env['name'].' - '.$env['alias']; ?></title>
<meta name="description" content="<?php echo $env['alias']; ?>">
<meta name="robots" content="noindex, nofollow">
<link rel="shortcut icon" href="assets/img/<?php echo $env['logo']; ?>">
<link rel="stylesheet" href="assets/js/plugins/select2/css/select2.min.css">
<link rel="stylesheet" id="css-main" href="assets/css/dashmix.min-5.4.css">
<link type="text/css" rel="stylesheet" href="assets/loader/waitMe.css">
<link rel="stylesheet" href="whatsapp/venom-button.min.css" />
</head>
<body>
  <div id="page-loader"><div class="loader-ring"></div></div>
<div id="page-container">
<main id="main-container">
<div>
<div class="row g-0 justify-content-center bg-primary-dark-op">
<div class="hero-static col-sm-8 col-md-8 col-l-8 col-xl-8 d-flex align-items-center p-2 px-sm-0">
<div class="block block-transparent block-rounded w-100 mb-0 overflow-hidden">
<div class="block-content block-content-full px-lg-5 px-xl-6 py-1 py-md-5 py-lg-6 bg-body-extra-light">
<div class="mb-2 text-center">
<img width="150" src="assets/img/<?php echo $env['logo']; ?>" class="mb-2"><br>
<a class=" fw-bold fs-3" >
<span class="text-dark"> <?php echo $env['name']; ?></span></a>
<p class="text-uppercase fw-bold fs-sm text-muted"><?php echo $env['alias']; ?></p>
</div>

<div class="block-content block-content-full space-y-3 ">
<div class="block block-rounded">

<form action="core/start_application" autocomplete="off" method="post"class="app_frm" enctype="multipart/form-data">
<ul class="nav nav-tabs nav-tabs-alt" role="tablist">
<li class="nav-item" role="presentation">
<button type="button" class="nav-link active" id="btabs-static-personal-tab" data-bs-toggle="tab" data-bs-target="#btabs-static-personal" role="tab" aria-controls="btabs-static-personal" aria-selected="true">Personal Information</button>
</li>
<li class="nav-item" role="presentation">
<button type="button" class="nav-link" id="btabs-static-education-tab" data-bs-toggle="tab" data-bs-target="#btabs-static-education" role="tab" aria-controls="btabs-static-education" aria-selected="false" tabindex="-1">Education Details</button>
</li>
</ul>
<div class="block-content tab-content">
<div class="alert alert-warning alert-dismissible fade show" role="alert">
<strong>Notice:</strong> You must fill in all required fields accurately.
Double-check your information before submitting the form.
</div>

<div class="alert alert-info">Already registered? click <a href="javascript:void(0);" data-bs-toggle="modal" data-bs-target="#modal-docket" data-bs-keyboard="false" data-bs-backdrop="static">HERE</a> to download admission card</div>
<div class="tab-pane fade active show" id="btabs-static-personal" role="tabpanel" aria-labelledby="btabs-static-personal-tab" tabindex="0">

<div class="row">
<div class="col-lg-4 col-sm-12 mb-3">
<label class="form-label">Surname</label>
<input type="text" name="sname" required placeholder="Enter surname here" class="form-control ">
</div>
<div class="col-lg-4 col-sm-12 mb-3">
<label class="form-label">Forname(s)</label>
<input type="text" name="fname" required placeholder="Enter forname(s) here" class="form-control ">
</div>
<div class="col-lg-4 col-sm-12 mb-3">
<label class="form-label">Gender</label>
<select class="form-control" name="gender" required>
<option value="" selected disabled>Select Gender</option>
<option value="Male">Male</option>
<option value="Female">Female</option>
</select>
</div>

</div>

<div class="row">
<div class="col-lg-4 col-sm-12 mb-3">
<label class="form-label">NRC Number (For Zambian Citizens)</label>
<input type="text" name="nrc" class="js-masked-nrc form-control"  placeholder="XXXXXX/XX/X">

</div>
<div class="col-lg-4 col-sm-12 mb-3">
<label class="form-label">Passport Number (For non Zambians)</label>
<input type="text" name="passport" placeholder="Enter passport number here" class="form-control ">
</div>

<div class="col-lg-4 col-sm-12 mb-3">
<label class="form-label">Birthday</label>
<input type="text" name="dob" required placeholder="Select Birthday" class="js-datepicker form-control" data-week-start="1" data-autoclose="true" data-today-highlight="true" data-date-format="yyyy-mm-dd">
</div>




</div>


<div class="row">
  <div class="col-lg-4 col-sm-12 mb-3">
  <label class="form-label">Nationality</label>
  <select name="nation" required class="form-control js-select2 form-select">
  <option value="" selected disabled>Select Country</option>

  <?php
  foreach ($country_list as $country) {
  ?><option value="<?php echo $country['nicename']; ?>"><?php echo $country['nicename']; ?></option><?php
  }
  ?>
  </select>
  </div>

<div class="col-lg-4 col-sm-12 mb-3">
<label class="form-label">Mobile Phone</label>
<input type="text" required  name="phone" class="form-control digi_input" placeholder="Enter mobile phone">
</div>
<div class="col-lg-4 col-sm-12 mb-3">
<label class="form-label">Email Address</label>
<input type="email" required  name="email" class="form-control" placeholder="Enter email address">
</div>
<div class="col-lg-4 col-sm-12 mb-3">
<label class="form-label">Which intake are you applying for</label>
<select name="intake" required class="form-control ">
<option value="" selected disabled>Select Intake</option>
<?php
foreach ($intake_list as $list) {
?><option value="<?php echo $list['id']; ?>"><?php echo $list['intake_name']; ?></option><?php
}
?>
</select>
</div>
<div class="col-lg-4 col-sm-12 mb-3">
<label class="form-label">Disability Status</label>
<select name="disabled" required class="form-control ">
<option value="" selected disabled>Select Option</option>
<option value="1">Yes</option>
<option value="0">No</option>
</select>
</div>
<div class="col-lg-4 col-sm-12 mb-3">
<label class="form-label">Nature of the disability</label>
<input type="text" name="nature" placeholder="Enter the nature of the disability" class="form-control ">
</div>

</div>

<div class="row">
<div class="col-lg-4 col-sm-12 mb-3">
<label class="form-label">Residental</label>
<input type="text" name="residental" required placeholder="Enter residental here" class="form-control ">
</div>
<div class="col-lg-4 col-sm-12 mb-3">
<label class="form-label">Postal Address</label>
<input type="text" name="postal_address" required placeholder="Enter postal address here" class="form-control ">
</div>
<div class="col-lg-4 col-sm-12 mb-3">
<label class="form-label">Next of Keen</label>
<input type="text" name="nok" required class="form-control"  placeholder="Enter next of kin here">
</div>
</div>

<div class="row">
<div class="col-lg-4 col-sm-12 mb-3">
<label class="form-label">Relationship</label>
<select name="nok_relationship" required class="form-control">
<option value="" selected disabled>Select Relationship</option>
<option value="Father">Father</option>
<option value="Mother">Mother</option>
<option value="Uncle">Uncle</option>
<option value="Aunt">Aunt</option>
<option value="Brother">Brother</option>
<option value="Sister">Sister</option>
<option value="Spouse">Spouse</option>
</select>
</div>


<div class="col-lg-4 col-sm-12 mb-3">
<label class="form-label">Next of Kin Mobile Phone</label>
<input type="text" required  name="kin_phone" class="form-control digi_input" placeholder="Enter mobile phone">
</div>

<div class="col-lg-4 col-sm-12 mb-3">
<label class="form-label">Next of Kin Postal Address</label>
<input type="text" name="nok_postal_address" required placeholder="Enter Next of Kin postal address here" class="form-control ">
</div>

</div>

<div class="row mb-4">

<div class="col-lg-12 col-sm-12 mb-2">
<label class="form-label">Next of Kin Residental</label>
<input type="text" name="nok_residental" required placeholder="Enter Next of Kin residental here" class="form-control ">
</div>


</div>
<div class="mt-4 text-end">
<button type="button" class="btn btn-primary" id="goEducationTab">Next</button>
</div>
</div>
<div class="tab-pane fade" id="btabs-static-education" role="tabpanel" aria-labelledby="btabs-static-education-tab" tabindex="0">
<div class="row">
<div class="col-lg-12 col-sm-12 mb-3">
<label class="form-label">High School</label>
<input type="text" name="highschool" required placeholder="Enter high school here" class="form-control ">
</div>
</div>
<div class="row">
<div class="col-lg-4 col-sm-12 mb-3">
<label class="form-label">Examination Number</label>
<input type="text" name="exam_number" required placeholder="Enter examination number here" class="form-control ">
</div>
<div class="col-lg-4 col-sm-12 mb-3">
<label class="form-label">Completion Year</label>
<input type="text" name="completion_year" required class="js-masked-year form-control"  placeholder="XXXX">
</div>
<div class="col-lg-4 col-sm-12 mb-3">
<label class="form-label">Mode of Study</label>
<select name="mode" required class="form-control">
<option value="" selected disabled>Select Mode</option>
<option value="Full Time">Full Time</option>
<option value="Distance (ODL)">Distance (ODL)</option>
</select>
</div>
</div>

<div class="row">
<div class="col-lg-12 col-sm-12 mb-3">
<label class="form-label">Academic Records</label>
<div class="dropzone dropzone-previews" id="meuDropZone"><center><div class="dz-message" data-dz-message><span>Click here to upload files</span></div></center></div>
</div>
</div>

<div class="row mb-4">



<div class="col-xl-12 col-l-12 col-md-12 col-sm-12 mb-2">
<label class="form-label">Programme category</label>
<select name="category" required class="form-control" onchange="get_programme_list(this.value);">
<option value="" selected disabled>Select Category</option>

<?php
foreach ($programme_types as $type) {
?><option value="<?php echo $type['id']; ?>"><?php echo $type['name']; ?></option><?php
}
?>
</select>
</div>

<div class="col-xl-4 col-l-4 col-md-12 col-sm-12 mb-2">
<label class="form-label">Programme Choice 1</label>
<select name="programme_1" id="programme_1" required class="form-control js-select2">
<option value="" selected disabled>Select Programme</option>

</select>
</div>

<div class="col-xl-4 col-l-4 col-md-12 col-sm-12 mb-2">
<label class="form-label">Programme Choice 2</label>
<select name="programme_2" id="programme_2" required class="form-control js-select2">
<option value="" selected disabled>Select Programme</option>

</select>
</div>

<div class="col-xl-4 col-l-4 col-md-12 col-sm-12 mb-2">
<label class="form-label">Programme Choice 3</label>
<select name="programme_3" id="programme_3" required class="form-control js-select2">
<option value="" selected disabled>Select Programme</option>

</select>
</div>

</div>
<div class="mt-4 d-flex justify-content-between">
<button type="button" class="btn btn-primary" id="goPersonalTab">Previous</button>
<button type="submit" class="btn btn-success">Submit</button>
</div>
</div>
</div>
<center><img title="We accept payments through MTN/AIRTEL Money and VISA(Any Credit and Debit ATM BANK CARD)" alt="We accept payments through MTN/AIRTEL Money and VISA(Any Credit and Debit ATM BANK CARD)" height='45' src="assets/img/pm.png" class="mb-2">
<br><i>We accept payments through MTN/AIRTEL Money and VISA(Any Credit and Debit ATM BANK CARD)</i>
</center><br>
</form>
</div>
</div>

</div>

</div>

</div>

</div>
</div>

<div class="modal fade" id="modal-docket" role="dialog" aria-labelledby="modal-docket"  data-bs-keyboard="false" data-bs-backdrop="static">
<div class="modal-dialog" role="document">
<div class="modal-content">
<div class="block block-rounded shadow-none mb-0">
<div class="block-header block-header-default">
<h4 class="block-title">Download Admission Card</h4>
</div>
<div class="block-content" id="card_response">
<div class="mb-2">
<label class="form-label">NRC / Passport Number</label>
<input type="text" required class="form-control" id="student_nrc" autocomplete="off" placeholder="Enter NRC / Passport Number">
</div>
<div class="mb-4">
<button type="button" class="btn btn-primary search_btn">Search</button>
<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
</div>
</div>
</div>
</div>
</div>
</div>
</main>
</div>
<div id="whatsappButton"></div>
<script src="assets/js/gru_oas.js"></script>
<script src="assets/js/lib/jquery.min.js"></script>
<script src="assets/loader/waitMe.js"></script>
<script src="assets/js/custom.js"></script>
<script src="assets/js/sweetalert.min.js"></script>
<script src="assets/js/plugins/select2/js/select2.full.min.js"></script>
<script src="assets/js/plugins/dropzone/min/dropzone.min.js"></script>
<script src="assets/js/plugins/bootstrap-datepicker/js/bootstrap-datepicker.min.js"></script>
<script src="assets/js/plugins/jquery.maskedinput/jquery.maskedinput.min.js"></script>
<script src="whatsapp/venom-button.min.js"></script>
<script>
$(".js-select2").select2({width: '100%'});

$(".js-masked-nrc").mask("999999/99/9");
$(".js-masked-year").mask("9999");

$(".js-datepicker").datepicker({
autoclose: true,
todayHighlight: true,
endDate: new Date(),
format: "yyyy-mm-dd",
orientation: "bottom"
});

$("#goEducationTab").on("click", function() {
new bootstrap.Tab(document.querySelector('#btabs-static-education-tab')).show();
});
$("#goPersonalTab").on("click", function() {
new bootstrap.Tab(document.querySelector('#btabs-static-personal-tab')).show();
});


Dropzone.autoDiscover = false;
jQuery(document).ready(function() {
$("div#meuDropZone").dropzone({
addRemoveLinks: true,
processing: function () {
$('.btn-success').prop('disabled', true);
},
removedfile: function(file) {
var name = file.name;
$.ajax({
type: 'POST',
url: 'ajax/delete.php',
data: "name="+name,
dataType: 'html'
});
var _ref;
return (_ref = file.previewElement) != null ? _ref.parentNode.removeChild(file.previewElement) : void 0;
},
url: "ajax/upload.php",
parallelUploads: 1,
maxFilesize: <?php echo (int)(ini_get('upload_max_filesize')); ?>,
maxFiles: 20,
init: function () {
var totalFiles = 0,
completeFiles = 0;
this.on("addedfile", function (file) {
totalFiles += 1;
});
this.on("removed file", function (file) {
totalFiles -= 1;
});
this.on("complete", function (file) {
completeFiles += 1;
if (completeFiles === totalFiles) {
$('.btn-success').prop('disabled', false);
}
});
},
acceptedFiles: ".pdf"
});

});

</script>

<script>
$('#whatsappButton').venomButton({
phone: '260977462120',
popupMessage: 'Hello, how can we help you?',
message: "",
showPopup: true,
position: "right",
linkButton: false,
headerTitle: 'Live Chat Support 24/7',
headerColor: '#25d366',
backgroundColor: '#25d366',
});

</script>
<?php $db->kill_conn(); require_once('assets/includes/check_reply.php'); ?>
</body>
</html>
