<?php
session_start();
require 'classes/database_class.php';
require 'classes/users_class.php';
require 'classes/util.php';
require 'classes/application_class.php';

$util = new util;
$users = new users;
$application = new application;
$env = $util->env();

if ($_SERVER['REQUEST_METHOD'] === 'GET' &&  !empty($_GET['response'])) {

$reference = $_GET['response'];
$base = 'https://api.lenco.co/access/v2/';
$secret_key = $env['lenco_secret_key'];
$curl = curl_init();
curl_setopt_array($curl, [
CURLOPT_URL => $base."collections/status/$reference",
CURLOPT_RETURNTRANSFER => true,
CURLOPT_ENCODING => "",
CURLOPT_MAXREDIRS => 10,
CURLOPT_TIMEOUT => 30,
CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
CURLOPT_CUSTOMREQUEST => "GET",
CURLOPT_HTTPHEADER => [
"Authorization: Bearer $secret_key",
"accept: application/json",
"content-type: application/json"
],
]);
$response = curl_exec($curl);
$err = curl_error($curl);
curl_close($curl);
if ($err) {
echo "cURL Error #:" . $err;
} else {

$the_app_id = str_replace("FOLDER_", "", $_SESSION["current_folder"]);

$id = time();
$email = $_SESSION['application']['email'];
$password = password_hash(strtoupper($_SESSION['application']['fname'].$_SESSION['application']['sname']), PASSWORD_BCRYPT);
$fname = strtoupper($_SESSION['application']['fname']);
$lname = strtoupper($_SESSION['application']['sname']);
$gender = $_SESSION['application']['gender'];
$level = 1;

$users->add_user($id, $fname, $lname, $gender, $email, $password, $level);

$application->create_application($the_app_id, NULL, NULL, $id);


$sname = strtoupper($_SESSION['application']['sname']);
$fname = strtoupper($_SESSION['application']['fname']);
$nrc = !empty($_SESSION['application']['nrc']) ? $_SESSION['application']['nrc'] : NULL;
$passport = !empty($_SESSION['application']['passport']) ? $_SESSION['application']['passport'] : NULL;
$dob = $_SESSION['application']['dob'];
$nation = $_SESSION['application']['nation'];
$phone = $_SESSION['application']['phone'];
$disabled = $_SESSION['application']['disabled'];
$nature = !empty($_SESSION['application']['nature']) ? $_SESSION['application']['nature'] : NULL;
$category = $_SESSION['application']['category'];
$intake = $_SESSION['application']['intake'];
$app_id = $the_app_id;

$application->update_personal($app_id, $sname, $fname, $nrc, $passport, $dob, $nation,$phone, $disabled, $nature, $category, $intake);


$residential = $_SESSION['application']['residental'];
$postal_address = $_SESSION['application']['postal_address'];
$nok = $_SESSION['application']['nok'];
$nok_relationship = $_SESSION['application']['nok_relationship'];
$nok_phone = $_SESSION['application']['phone'];
$nok_residental = $_SESSION['application']['nok_residental'];
$nok_postal_address = $_SESSION['application']['nok_postal_address'];
$app_id = $the_app_id;

$application->update_address($app_id, $residential, $postal_address, $nok, $nok_relationship, $nok_phone, $nok_residental, $nok_postal_address);


$highschool = $_SESSION['application']['highschool'];
$exam_number = $_SESSION['application']['exam_number'];
$completion_year = $_SESSION['application']['completion_year'];
$mode = $_SESSION['application']['mode'];
$choice1 = $_SESSION['application']['programme_1'];
$choice2 = $_SESSION['application']['programme_2'];
$choice3 = $_SESSION['application']['programme_3'];
$app_id = $the_app_id;

$application->update_education($app_id, $exam_number, $completion_year, $highschool, $mode, $choice1, $choice2, $choice3);

$application->save_transaction($app_id, $response);

unset($_SESSION['application']);

header("location:../admission_card?id=$app_id");

}
}else{
http_response_code(403);
}
?>
