<?php
session_start();
chdir('../');
require 'classes/database_class.php';
require 'classes/util.php';
require 'classes/application_class.php';
require 'classes/users_class.php';
require 'classes/session_class.php';
require 'classes/accounts_class.php';

$util = new util;
$application = new application;
$users = new users;
$session = new session;
$accounts = new accounts;
$env = $util->env();

$red = $_SESSION['domain'];


$_SESSION['dpo_config'] = [$env['DPO_COMPANY_TOKEN'], $env['DPO_SERVICE_TYPE'], $env['DPO_API_URL']];

require 'classes/dpo_class.php';

try {

$amount = floatval($_SESSION['current_fee']);
$email = $_SESSION['application']['email'];
$firstName = $_SESSION['application']['fname'];
$lastName = $_SESSION['application']['sname'];
$description = 'Application Fee Payment';
$currency = 'ZMW';
$transactionRef = 'TXN-' . date('YmdHis') . '-' . rand(1000, 9999);

$dpo = new DPOPayment();

$response = $dpo->createTransaction($amount, $email, $firstName, $lastName, $transactionRef, $description, $currency);


if (isset($response['TransToken']) && !empty($response['TransToken'])) {
$_SESSION['transaction'] = [
'token' => $response['TransToken'],
'reference' => $transactionRef,
'amount' => $amount,
'email' => $email,
'status' => 'pending'
];

$paymentUrl = 'https://secure.3gdirectpay.com/payv2.php?ID' . $response['TransToken'];
header("location: $paymentUrl");
exit();
} else {
$error = $response['ResultExplanation'] ?? 'Unknown error occurred';
throw new Exception($error);
}
} catch (Exception $e) {
echo "<h2>Payment Error</h2>";
echo "<p>" . htmlspecialchars($e->getMessage()) . "</p>";
echo "<a href='../payment'>Try again</a>";
exit();
}
?>
