<?php
class users extends database {

public function add_user($id, $fname, $lname, $gender, $email, $password, $level) {
$sql = 'INSERT INTO users (id, fname, lname, gender, email, hashed_pw, level) VALUES (?,?,?,?,?,?,?)';
$stmt = $this->conn->prepare($sql);
$stmt->execute([$id, $fname, $lname, $gender, $email, $password, $level]);
return true;
}

public function get_users() {
$sql = "SELECT * FROM users ORDER BY id DESC";
$stmt = $this->conn->prepare($sql);
$stmt->execute();
$result = $stmt->fetchAll();
return $result;
}

public function get_user($user_id) {
$sql = 'SELECT * FROM users WHERE id = ?';
$stmt = $this->conn->prepare($sql);
$stmt->execute([$user_id]);
$result = $stmt->fetchAll();
return $result;
}

public function auth_user($email) {
$sql = 'SELECT * FROM users WHERE email = ?';
$stmt = $this->conn->prepare($sql);
$stmt->execute([$email]);
$result = $stmt->fetchAll();
return $result;
}

public function valid_email2($email) {
$sql = 'SELECT * FROM users WHERE email = ?';
$stmt = $this->conn->prepare($sql);
$stmt->execute([$email]);
$result = $stmt->fetchAll();
if (count($result) < 1) { return true; } else { return false; }
}

public function valid_email($email, $user) {
$sql = 'SELECT * FROM users WHERE email = ? AND id != ?';
$stmt = $this->conn->prepare($sql);
$stmt->execute([$email, $user]);
$result = $stmt->fetchAll();
if (count($result) < 1) { return true; } else { return false; }
}

public function update_user($fname, $lname, $gender, $email, $password, $user_id) {
$sql = 'UPDATE users SET fname = ?, lname = ?, gender = ?, email = ?, hashed_pw = ? WHERE id = ?';
$stmt = $this->conn->prepare($sql);
$stmt->execute([$fname, $lname, $gender, $email, $password, $user_id]);
return true;
}

public function update_user2($fname, $lname, $gender, $email, $status, $user_id) {
$sql = 'UPDATE users SET fname = ?, lname = ?, gender = ?, email = ?, status = ? WHERE id = ?';
$stmt = $this->conn->prepare($sql);
$stmt->execute([$fname, $lname, $gender, $email, $status, $user_id]);
return true;
}

public function update_password($pass, $id) {
$sql = 'UPDATE users SET hashed_pw = ? WHERE id = ?';
$stmt = $this->conn->prepare($sql);
$stmt->execute([$pass, $id]);
return true;
}

public function delete_user($user_id) {
$sql = 'DELETE FROM users WHERE id = ?';
$stmt = $this->conn->prepare($sql);
$stmt->execute([$user_id]);
return true;
}


}
?>
