<?php

class DPOPayment {
private $companyToken;
private $serviceType;

public function __construct() {
$this->companyToken = $_SESSION['dpo_config'][0];
$this->serviceType = $_SESSION['dpo_config'][1];
}

public function createTransaction($amount, $customerEmail, $customerFirstName, $customerLastName, $transactionRef, $description, $currency) {
try {
$xmlRequest = $this->buildCreateTokenRequest($amount, $customerEmail, $customerFirstName, $customerLastName, $transactionRef, $description, $currency);
$this->logError("Request XML", $xmlRequest);

$response = $this->sendRequest($xmlRequest);
$this->logError("Raw Response", $response);

$parsedResponse = $this->parseResponse($response);
$this->logError("Parsed Response", $parsedResponse);

return $parsedResponse;
} catch (Exception $e) {
$this->logError($e->getMessage());
throw $e;
}
}


public function verifyTransaction($transactionToken) {
$xmlRequest = $this->buildVerifyTokenRequest($transactionToken);
$response = $this->sendRequest($xmlRequest);

return $this->parseResponse($response);
}

private function buildCreateTokenRequest($amount, $customerEmail, $customerFirstName, $customerLastName, $transactionRef, $description, $currency) {

$cleanServiceType = preg_replace('/[^\x20-\x7E]/', '', $this->serviceType);

return '<?xml version="1.0" encoding="utf-8"?>
<API3G>
<CompanyToken>' . $this->companyToken . '</CompanyToken>
<Request>createToken</Request>
<Transaction>
<PaymentAmount>' . number_format($amount, 2, '.', '') . '</PaymentAmount>
<PaymentCurrency>' . $currency . '</PaymentCurrency>
<CompanyRef>' . $transactionRef . '</CompanyRef>
<RedirectURL>' . $_SESSION['dpo_links'][0] . '</RedirectURL>
<BackURL>' . $_SESSION['dpo_links'][1] . '</BackURL>
<CompanyRefUnique>0</CompanyRefUnique>
<PTL>1</PTL>
</Transaction>
<Services>
<Service>
<ServiceType>' . $cleanServiceType . '</ServiceType>
<ServiceDescription>' . htmlspecialchars($description) . '</ServiceDescription>
<ServiceDate>' . date('Y/m/d H:i') . '</ServiceDate>
</Service>
</Services>
<Customer>
<CustomerEmail>' . $customerEmail . '</CustomerEmail>
<CustomerFirstName>' . $customerFirstName . '</CustomerFirstName>
<CustomerLastName>' . $customerLastName . '</CustomerLastName>
</Customer>
</API3G>';
}

private function buildVerifyTokenRequest($transactionToken) {
return '<?xml version="1.0" encoding="utf-8"?>
<API3G>
<CompanyToken>' . $this->companyToken . '</CompanyToken>
<Request>verifyToken</Request>
<TransactionToken>' . $transactionToken . '</TransactionToken>
</API3G>';
}

private function sendRequest($xmlRequest) {
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $_SESSION['dpo_config'][2]);
curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: text/xml'));
curl_setopt($ch, CURLOPT_POST, 1);
curl_setopt($ch, CURLOPT_POSTFIELDS, $xmlRequest);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_HEADER, 1);

$response = curl_exec($ch);

if (curl_errno($ch)) {
throw new Exception('Curl error: ' . curl_error($ch));
}

$header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
$headers = substr($response, 0, $header_size);
$body = substr($response, $header_size);

curl_close($ch);

if (stripos($body, '<!DOCTYPE html>') !== false || stripos($body, '<html>') !== false) {
throw new Exception('DPO API returned an HTML error page instead of XML response');
}

return $body;
}

private function parseResponse($xmlResponse) {

libxml_use_internal_errors(true);
$xml = simplexml_load_string($xmlResponse);

if ($xml === false) {
$errors = libxml_get_errors();
$errorMessages = [];
foreach ($errors as $error) {
$errorMessages[] = "Line {$error->line}: {$error->message}";
}
libxml_clear_errors();

file_put_contents('dpo_error_log.txt', "Failed to parse XML. Response was:\n" . $xmlResponse . "\n", FILE_APPEND);

throw new Exception('Failed to parse XML response: ' . implode(', ', $errorMessages));
}

return json_decode(json_encode($xml), true);
}

private function logError($message, $data = null) {
$logMessage = date('Y-m-d H:i:s') . " - ERROR: " . $message . "\n";
if ($data) {
$logMessage .= "Data: " . print_r($data, true) . "\n";
}
file_put_contents('dpo_payment_errors.log', $logMessage, FILE_APPEND);
}

}
?>
