<?php
class application extends database {

public function create_application($app_id, $can, $scn, $user) {
$sql = 'INSERT INTO applications (app_id, can, scn, user) VALUES (?,?,?,?)';
$stmt = $this->conn->prepare($sql);
$stmt->execute([$app_id, $can, $scn, $user]);
return true;
}

public function check_application($user) {
$sql = "SELECT * FROM applications WHERE user = ?";
$stmt = $this->conn->prepare($sql);
$stmt->execute([$user]);
$result = $stmt->fetchAll();
if (count($result) > 0) { return true; } else { return false; }
}

public function get_application($user) {
$sql = "SELECT * FROM applications WHERE user = ?";
$stmt = $this->conn->prepare($sql);
$stmt->execute([$user]);
$result = $stmt->fetchAll();
return $result;
}

public function get_cards($id) {
$sql = "SELECT * FROM personal_details LEFT JOIN programme_types ON personal_details.programme_type = programme_types.id
LEFT JOIN intakes ON personal_details.intake = intakes.id LEFT JOIN applications ON personal_details.app_id = applications.app_id LEFT JOIN
users ON applications.user = users.id WHERE personal_details.nrc = ? OR personal_details.passport_no = ?";
$stmt = $this->conn->prepare($sql);
$stmt->execute([$id, $id]);
$result = $stmt->fetchAll();
return $result;
}

public function get_application_by_email($email) {
$sql = "SELECT * FROM applications LEFT JOIN users ON applications.user = users.id WHERE users.email = ?";
$stmt = $this->conn->prepare($sql);
$stmt->execute([$email]);
$result = $stmt->fetchAll();
return $result;
}


public function get_programme_types() {
$sql = "SELECT * FROM programme_types";
$stmt = $this->conn->prepare($sql);
$stmt->execute();
$result = $stmt->fetchAll();
return $result;
}

public function get_basic_profile($id) {
$sql = "SELECT * FROM applications LEFT JOIN users ON applications.user = users.id WHERE applications.app_id = ?";
$stmt = $this->conn->prepare($sql);
$stmt->execute([$id]);
$result = $stmt->fetchAll();
return $result;
}

public function get_programme_choices($type) {
$sql = "SELECT * FROM programmes WHERE type = ?";
$stmt = $this->conn->prepare($sql);
$stmt->execute([$type]);
$result = $stmt->fetchAll();
return $result;
}

public function get_programme_name($id) {
$sql = "SELECT * FROM programmes WHERE id = ?";
$stmt = $this->conn->prepare($sql);
$stmt->execute([$id]);
$result = $stmt->fetchAll();
return $result[0]['name'];
}

public function get_countries() {
$sql = "SELECT nicename FROM countries ORDER BY nicename";
$stmt = $this->conn->prepare($sql);
$stmt->execute();
$result = $stmt->fetchAll();
return $result;
}

public function update_application($can, $scn, $app_id) {
$sql = 'UPDATE applications SET can = ?, scn = ? WHERE app_id = ?';
$stmt = $this->conn->prepare($sql);
$stmt->execute([$can, $scn, $app_id]);
return true;
}

public function update_status($status, $app_id) {
$sql = 'UPDATE applications SET completed = ? WHERE app_id = ?';
$stmt = $this->conn->prepare($sql);
$stmt->execute([$status, $app_id]);
return true;
}

public function bypass_fee($app_id, $callback) {
$sql = 'INSERT INTO payments (app_id, callback_data) VALUES (?,?)';
$stmt = $this->conn->prepare($sql);
$stmt->execute([$app_id, $callback]);
return true;
}

public function get_fees() {
$sql = 'SELECT * FROM payments ORDER BY id DESC';
$stmt = $this->conn->prepare($sql);
$stmt->execute();
$result = $stmt->fetchAll();
return $result;
}

public function check_nrc($nrc) {
$sql = "SELECT nrc FROM personal_details WHERE nrc = ? AND nrc IS NOT NULL";
$stmt = $this->conn->prepare($sql);
$stmt->execute([$nrc]);
$result = $stmt->fetchAll();
if (count($result) < 1) { return true; } else { return false; }
}

public function check_exam_number($no) {
$sql = "SELECT exam_number FROM education WHERE exam_number = ?";
$stmt = $this->conn->prepare($sql);
$stmt->execute([$no]);
$result = $stmt->fetchAll();
if (count($result) < 1) { return true; } else { return false; }
}

public function check_passport($passport) {
$sql = "SELECT passport_no FROM personal_details WHERE passport_no = ? AND passport_no IS NOT NULL";
$stmt = $this->conn->prepare($sql);
$stmt->execute([$passport]);
$result = $stmt->fetchAll();
if (count($result) < 1) { return true; } else { return false; }
}

public function get_personal_details($app_id) {
$sql = "SELECT * FROM personal_details LEFT JOIN programme_types ON personal_details.programme_type = programme_types.id
LEFT JOIN intakes ON personal_details.intake = intakes.id LEFT JOIN applications ON personal_details.app_id = applications.app_id LEFT JOIN
users ON applications.user = users.id WHERE personal_details.app_id = ?";
$stmt = $this->conn->prepare($sql);
$stmt->execute([$app_id]);
$result = $stmt->fetchAll();
return $result;
}

public function get_application_fee($app_id) {
$sql = "SELECT * FROM payments WHERE app_id = ?";
$stmt = $this->conn->prepare($sql);
$stmt->execute([$app_id]);
$result = $stmt->fetchAll();
return $result;
}

public function get_address_details($app_id) {
$sql = "SELECT * FROM address WHERE app_id = ?";
$stmt = $this->conn->prepare($sql);
$stmt->execute([$app_id]);
$result = $stmt->fetchAll();
return $result;
}

public function get_education_details($app_id) {
$sql = "SELECT * FROM education WHERE app_id = ?";
$stmt = $this->conn->prepare($sql);
$stmt->execute([$app_id]);
$result = $stmt->fetchAll();
return $result;
}

public function save_transaction($app_id, $response) {
$sql = 'INSERT INTO payments (app_id, callback_data) VALUES (?,?)';
$stmt = $this->conn->prepare($sql);
$stmt->execute([$app_id, $response]);
return true;
}

public function update_personal($app_id, $surname, $fornames, $nrc, $passport, $dob, $nationality,$mobile, $disability, $nature, $programme_type, $intake) {
$sql = "INSERT INTO personal_details (app_id, surname, fornames, nrc, passport_no, dob, nationality, mobile_no, disability, nature, programme_type, intake) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
$stmt = $this->conn->prepare($sql);
$stmt->execute([$app_id, $surname, $fornames, $nrc, $passport, $dob, $nationality,$mobile, $disability, $nature, $programme_type, $intake]);
return true;
}

public function update_personal_intake($app_id, $intake) {
$sql = "UPDATE personal_details SET intake = ? WHERE app_id = ?";
$stmt = $this->conn->prepare($sql);
$stmt->execute([$intake, $app_id]);
return true;
}

public function update_address($app_id, $residential, $postal_address, $next_of_kin, $nok_relationship, $nok_phone, $nok_residential, $nok_postal_address) {
$sql = "INSERT INTO address (app_id, residential, postal_address, next_of_kin, nok_relationship, nok_phone, nok_residential, nok_postal_address) VALUES (?,?,?,?,?,?,?,?)";
$stmt = $this->conn->prepare($sql);
$stmt->execute([$app_id, $residential, $postal_address, $next_of_kin, $nok_relationship, $nok_phone, $nok_residential, $nok_postal_address]);
return true;
}

public function update_education($app_id, $exam_no, $year, $school, $mode, $ch1, $ch2, $ch3) {
$sql = "INSERT INTO education (app_id, exam_number, completion_year, hig_school, mode_of_study, choice_1, choice_2, choice_3) VALUES (?,?,?,?,?,?,?,?)";
$stmt = $this->conn->prepare($sql);
$stmt->execute([$app_id, $exam_no, $year, $school, $mode, $ch1, $ch2, $ch3]);
return true;
}

public function complete_admission($app_id) {
$sql = "UPDATE applications SET completed = '1' WHERE app_id = ?";
$stmt = $this->conn->prepare($sql);
$stmt->execute([$app_id]);
return true;
}

public function get_txn() {
$sql = "SELECT a.app_id, a.callback_data, b.surname, b.fornames, b.nrc, b.passport_no FROM payments a LEFT JOIN personal_details b ON a.app_id = b.app_id ORDER BY a.id ASC";
$stmt = $this->conn->prepare($sql);
$stmt->execute();
$result = $stmt->fetchAll();
return $result;
}

public function get_selection($intake) {
$sql = "SELECT a.app_id, b.surname, b.fornames, b.nrc, b.passport_no, c.name, e.name as level FROM applications a
LEFT JOIN personal_details b ON a.app_id = b.app_id
LEFT JOIN education d ON a.app_id = d.app_id
LEFT JOIN programmes c ON d.choice_1 = c.id
LEFT JOIN programme_types e ON c.type = e.id WHERE b.intake = ?
ORDER BY a.id ASC";
$stmt = $this->conn->prepare($sql);
$stmt->execute([$intake]);
$result = $stmt->fetchAll();
return $result;
}

}
?>
