<?php
class accounts extends database {

public function auth_user($email) {
$sql = 'SELECT * FROM users WHERE email = ?';
$stmt = $this->conn->prepare($sql);
$stmt->execute([$email]);
$result = $stmt->fetchAll();
return $result;
}

public function logged_user() {
$current_user = $_SESSION['logged_account'];
switch ($_SESSION['logged_level']) {
case '0':
return $this->fetch_user($_SESSION['logged_account'], "users");
break;

case '1':
return $this->fetch_user($_SESSION['logged_account'], "artists");
break;
}
}


public function get_permissions($group) {
$sql = 'SELECT * FROM user_groups WHERE id = ?';
$stmt = $this->conn->prepare($sql);
$stmt->execute([$group]);
$result = $stmt->fetchAll();
return unserialize($result[0]['permissions']);
}

public function get_group($group) {
$sql = 'SELECT * FROM user_groups WHERE id = ?';
$stmt = $this->conn->prepare($sql);
$stmt->execute([$group]);
$result = $stmt->fetchAll();
return $result[0]['group_name'];
}


public function valid_email($email, $user) {
$sql = 'SELECT email FROM users WHERE email = ? AND id != ? UNION SELECT email FROM artists WHERE email = ? AND id != ?';
$stmt = $this->conn->prepare($sql);
$stmt->execute([$email, $user, $email, $user]);
$result = $stmt->fetchAll();
if (count($result) < 1) { return true; } else { return false; }
}

public function update_profile($table, $data) {

switch ($table) {
case 'users':

$sql = 'UPDATE users SET first_name=?, last_name=?, email = ?, phone=? WHERE id = ?';
$stmt = $this->conn->prepare($sql);
$stmt->execute([$data['fname'], $data['lname'], $data['email'], $data['phone'], $data['id']]);
return true;

break;

case 'artists':

$sql = 'UPDATE artists SET first_name=?, middle_name=?, last_name=?, artist_name=?, email = ?, gender=?, birthday=?, phone=? WHERE id = ?';
$stmt = $this->conn->prepare($sql);
$stmt->execute([$data['fname'], $data['mname'], $data['lname'], $data['artist_name'], $data['email'], $data['gender'], $data['birthday'], $data['phone'], $data['id']]);
return true;

break;
}
}

}
?>
