<?php
session_start();
chdir('../../');
require 'classes/database_class.php';
require 'classes/util.php';
require 'classes/users_class.php';
require 'classes/session_class.php';
require 'classes/accounts_class.php';

$db = new database;
$util = new util;
$users = new users;
$session = new session;
$accounts = new accounts;
$env = $util->env();

if ($session->is_logged()) {

$table = <<<EOT
(
SELECT a.id as id, a.name as course, b.name as category FROM programmes a LEFT JOIN programme_types b ON a.type = b.id ORDER BY a.name
) temp
EOT;

$primaryKey = 'id';

$columns = array(
array( 'db' => 'course',   'dt' => 0 ),
array( 'db' => 'category',   'dt' => 1 ),
array(
'db'        => 'id',
'dt'        => 2,
'formatter' => function( $d, $row ) {
return "
<button onclick='get_programme($d);' type='button' class='btn btn-primary btn-sm' data-bs-toggle='modal' data-bs-target='#modal-edit' data-bs-keyboard='false' data-bs-backdrop='static'>Edit</button>
<button onclick='drop(".htmlspecialchars_decode('&#039')."app/core/delete_programme?id=$d".htmlspecialchars_decode('&#039').",".htmlspecialchars_decode('&#039')."Delete Programme?".htmlspecialchars_decode('&#039').");' type='button' class='btn btn-danger btn-sm'>Delete</button>
";
}
)
);


$sql_details = array(
'user' => $db->_db[1],
'pass' => $db->_db[2],
'db'   => $db->_db[3],
'host' => $db->_db[0]
,'charset' => 'utf8'
);

require('includes/ssp.class.php');

echo json_encode(
SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns )
);


}else{
http_response_code(403);
}
?>
