<?php
session_start();
chdir('../../');
require 'classes/database_class.php';
require 'classes/util.php';
require 'classes/users_class.php';
require 'classes/session_class.php';
require 'classes/accounts_class.php';

$db = new database;
$util = new util;
$users = new users;
$session = new session;
$accounts = new accounts;
$env = $util->env();

if ($session->is_logged()) {

$app_type = $_GET['application_type'];

switch ($app_type) {
case '0':

$table = <<<EOT
(
SELECT a.app_id, a.completed,
b.surname, b.fornames, b.nrc, b.passport_no
FROM applications a
LEFT JOIN personal_details b ON a.app_id = b.app_id
WHERE a.completed != $app_type
ORDER BY a.id ASC
) temp
EOT;

break;

case '1':

$table = <<<EOT
(
SELECT a.app_id, a.completed,
b.surname, b.fornames, b.nrc, b.passport_no
FROM applications a
LEFT JOIN personal_details b ON a.app_id = b.app_id
WHERE a.completed = $app_type
ORDER BY a.id ASC
) temp
EOT;

case '2':

$table = <<<EOT
(
SELECT a.app_id, a.completed,
b.surname, b.fornames, b.nrc, b.passport_no
FROM applications a
LEFT JOIN personal_details b ON a.app_id = b.app_id
WHERE a.completed = $app_type
ORDER BY a.id ASC
) temp
EOT;

break;

case '3':

$table = <<<EOT
(
SELECT a.app_id, a.completed,
b.surname, b.fornames, b.nrc, b.passport_no
FROM applications a
LEFT JOIN personal_details b ON a.app_id = b.app_id
WHERE a.completed = $app_type
ORDER BY a.id ASC
) temp
EOT;

}

$primaryKey = 'app_id';

$columns = array(
array(
'db'        => 'app_id',
'dt'        => 0,
'formatter' => function( $d, $row ) {
$page = $GLOBALS['app_type'];
return "
<a class='fw-semibold' href='javascript:void(0);' onclick='get_application(".htmlspecialchars_decode('&#039')." $d ".htmlspecialchars_decode('&#039').", ".htmlspecialchars_decode('&#039')." $page ".htmlspecialchars_decode('&#039').");' data-bs-toggle='modal' data-bs-target='#modal-order' data-bs-keyboard='false' data-bs-backdrop='static'><strong>$d</strong></a>
";
}
),
array( 'db' => 'surname',   'dt' => 1 ),
array( 'db' => 'fornames',   'dt' => 2 ),

array(
'db'        => 'nrc',
'dt'        => 3,
'formatter' => function( $d, $row ) {
return !empty($d) ? $d : "Not Applicable";
}
),

array(
'db'        => 'passport_no',
'dt'        => 4,
'formatter' => function( $d, $row ) {
return !empty($d) ? $d : "Not Applicable";
}
),

array(
'db'        => 'completed',
'dt'        => 5,
'formatter' => function( $d, $row ) {
switch ($d) {
case '1':
return '<span class="badge rounded-pill bg-warning">PENDING</span>';
break;

case '2':
return '<span class="badge rounded-pill bg-success">APPROVED</span>';
break;

case '3':
return '<span class="badge rounded-pill bg-danger">DENIED</span>';
break;
}
}
),

array(
'db'        => 'app_id',
'dt'        => 6,
'formatter' => function( $d, $row ) {
$page = $GLOBALS['app_type'];
return "
<button onclick='get_application(".htmlspecialchars_decode('&#039')." $d ".htmlspecialchars_decode('&#039').", ".htmlspecialchars_decode('&#039')." $page ".htmlspecialchars_decode('&#039').");' type='button' class='btn btn-primary btn-sm' data-bs-toggle='modal' data-bs-target='#modal-order' data-bs-keyboard='false' data-bs-backdrop='static'>View</button>
";
}
)
);


$sql_details = array(
'user' => $db->_db[1],
'pass' => $db->_db[2],
'db'   => $db->_db[3],
'host' => $db->_db[0]
,'charset' => 'utf8'
);

require('includes/ssp.class.php');

echo json_encode(
SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns )
);


}else{
http_response_code(403);
}
