<?php
if (isset($is_authorized) && $is_authorized > 0 && $current_user[0]['level'] == "1" || $current_user[0]['level'] == "4") {

require 'classes/application_class.php';

$application = new application;
$country_list = $application->get_countries();
$programme_types = $application->get_programme_types();
$personal_details = $application->get_personal_details($_SESSION['app_details'][0]['app_id']);
$application_fee = $application->get_application_fee($_SESSION['app_details'][0]['app_id']);
$address_details = $application->get_address_details($_SESSION['app_details'][0]['app_id']);
$education_details = $application->get_education_details($_SESSION['app_details'][0]['app_id']);

if (count($personal_details) > 0) { $programme_choices = $application->get_programme_choices($personal_details[0]['programme_type']); }

$util = new util;
$env = $util->env();

if(!isset($_SESSION["current_folder"])) {
$_SESSION["current_folder"] = strtoupper('folder_'.$_SESSION['app_details'][0]['app_id']);
$unlink_dir = 'uploads/'.$_SESSION["current_folder"].'/';
}else{

$unlink_dir = 'uploads/'.$_SESSION["current_folder"].'/';

if (count($education_details) < 1) {
array_map('unlink', array_filter((array) glob("$unlink_dir*")));
}else{
if ($_SESSION['app_details'][0]['completed'] < 1) {

$pth = 'uploads/'.strtoupper('folder_'.$_SESSION['app_details'][0]['app_id']).'/';

$files = glob($pth.'*.{pdf}', GLOB_BRACE);

$application->complete_admission($_SESSION['app_details'][0]['app_id']);

foreach($files as $file) {
$new_name = $pth.$filename = pathinfo($file, PATHINFO_FILENAME).'.grudoc';
rename($file, $new_name);
}

}
}

}

?>
<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1.0">
<title><?php echo $env['name'].' - '.ucwords(str_replace("_"," ", $_GET['page'])).''; ?></title>
<meta name="description" content="<?php echo $env['alias']; ?>">
<base href="../">
<link rel="shortcut icon" href="assets/img/<?php echo $env['logo']; ?>">
<link rel="stylesheet" id="css-main" href="assets/css/dashmix.min-5.4.css">

<link rel="stylesheet" href="assets/js/plugins/bootstrap-datepicker/css/bootstrap-datepicker3.min.css">
<link rel="stylesheet" href="assets/js/plugins/dropzone/min/dropzone.min.css">
<link rel="stylesheet" href="assets/js/plugins/flatpickr/flatpickr.min.css">
<link rel="stylesheet" href="assets/css/intlTelInput.min.css">
<link type="text/css" rel="stylesheet" href="assets/loader/waitMe.css">
<link rel="stylesheet" href="assets/js/plugins/select2/css/select2.min.css">
<link rel="stylesheet" href="whatsapp/venom-button.min.css" />
</head>
<body>
<div id="page-loader"><div class="loader-ring"></div></div>
<div id="page-container" class="page-container2 sidebar-o sidebar-light enable-page-overlay side-scroll page-header-fixed  page-header-dark">

<?php require_once 'includes/header.php'; ?>

<main id="main-container">
<div class="content">
<div class="d-md-flex justify-content-md-between align-items-md-center py-3 pt-md-3 pb-md-0 text-center text-md-start">
<div>
<h1 class="h3 mb-1">
<?php echo ucwords(str_replace("_"," ", $_GET['page'])); ?>
</h1>
</div>

</div>
</div>
<div class="content">
<div class="block block-rounded">

<div class="block-content block-content-full">
<?php
if (count($application_fee) < 1) {

?>
<div class="alert alert-warning d-flex align-items-center justify-content-between" role="alert">
<div class="flex-grow-1 me-3">
<p class="mb-0">You must finish a previous step "<strong>Address Details</strong>" before proceeding with "<strong>Education Details</strong>"</p>
</div>
<div class="flex-shrink-0">
<i class="fa fa-fw fa-exclamation-circle"></i>
</div>
</div>

<center>
<div class="btn-group btn-group-lg mt-4" role="group" aria-label="Large Horizontal Alternate Primary">
<a href="app?page=address_details" class="btn btn-alt-secondary">
<i class="fa fa-arrow-left"></i> Previous
</a>
</div>
</center>
<?php
}else{

if (count($education_details) < 1) {

?>
<form action="app/core/update_education" autocomplete="OFF" method="POST" class="app_frm">

<div class="row">
<div class="col-lg-4 col-sm-12 mb-3">
<label class="form-label">High School</label>
<input type="text" name="highschool" required placeholder="Enter high school here" class="form-control ">
</div>
<div class="col-lg-4 col-sm-12 mb-3">
<label class="form-label">Examination Number</label>
<input type="text" name="exam_number" required placeholder="Enter examination number here" class="form-control ">
</div>
<div class="col-lg-4 col-sm-12 mb-3">
<label class="form-label">Completion Year</label>
<input type="text" name="completion_year" required class="js-masked-year form-control"  placeholder="XXXX">
</div>
</div>

<div class="row">
<div class="col-lg-4 col-sm-12 mb-3">
<label class="form-label">Mode of Study</label>
<select name="mode" required class="form-control">
<option value="" selected disabled>Select Mode</option>
<option value="Full Time">Full Time</option>
<option value="Distance (ODL)">Distance (ODL)</option>
</select>
</div>
</div>

<div class="row">
<div class="col-lg-12 col-sm-12 mb-3">
<label class="form-label">Academic Records</label>
<div class="dropzone dropzone-previews" id="meuDropZone"><center><div class="dz-message" data-dz-message><span>Drop files here to upload</span></div></center></div>
</div>
</div>

<h2 class="content-heading pt-0">Programme Choice</h2>

<div class="row">
<div class="col-lg-4 col-sm-12 mb-4">
<label class="form-label">Choice 1</label>
<select name="choice1" required class="form-control js-select2 form-select">
<option value="" selected disabled>Select Choice 1</option>
<?php
foreach ($programme_choices as $choice) {
?><option value="<?php echo $choice['id']; ?>"><?php echo $choice['name']; ?></option><?php
}
?>
</select>
</div>

<div class="col-lg-4 col-sm-12 mb-4">
<label class="form-label">Choice 2</label>
<select name="choice2" required class="form-control js-select2 form-select">
<option value="" selected disabled>Select Choice 2</option>
<?php
foreach ($programme_choices as $choice) {
?><option value="<?php echo $choice['id']; ?>"><?php echo $choice['name']; ?></option><?php
}
?>
</select>
</div>

<div class="col-lg-4 col-sm-12 mb-4">
<label class="form-label">Choice 3</label>
<select name="choice3" required class="form-control js-select2 form-select">
<option value="" selected disabled>Select Choice 3</option>
<?php
foreach ($programme_choices as $choice) {
?><option value="<?php echo $choice['id']; ?>"><?php echo $choice['name']; ?></option><?php
}
?>
</select>
</div>
</div>

<input type="hidden" name="app_id" value="<?php echo $_SESSION['app_details'][0]['app_id']; ?>">
<div class="mb-2">
<button type="submit" class="btn btn-primary">Save Changes</button>
</div>

</form>

<center>
<div class="btn-group btn-group-lg mt-4" role="group" aria-label="Large Horizontal Alternate Primary">
<a href="app?page=address_details" class="btn btn-alt-secondary">
<i class="fa fa-arrow-left"></i> Previous
</a>
</div>
</center>
<?php

}else{


?>
<div class="mb-1">
<label class="form-label">High School</label>
<input type="text" readonly class="form-control-plaintext" value="<?php echo $education_details[0]['hig_school']; ?>">
</div>
<div class="mb-1">
<label class="form-label" >Examination Number</label>
<input type="text" readonly class="form-control-plaintext" value="<?php echo $education_details[0]['exam_number']; ?>">
</div>
<div class="mb-1">
<label class="form-label" >Completion Year</label>
<input type="text" readonly class="form-control-plaintext" value="<?php echo $education_details[0]['completion_year']; ?>">
</div>
<div class="mb-1">
<label class="form-label" >Mode of Study</label>
<input type="text" readonly class="form-control-plaintext" value="<?php echo $education_details[0]['mode_of_study']; ?>">
</div>
<div class="mb-1">
<label class="form-label" >Programme Choice 1</label>
<input type="text" readonly class="form-control-plaintext" value="<?php echo $application->get_programme_name($education_details[0]['choice_1']); ?>">
</div>
<div class="mb-1">
<label class="form-label" >Programme Choice 2</label>
<input type="text" readonly class="form-control-plaintext" value="<?php echo $application->get_programme_name($education_details[0]['choice_2']); ?>">
</div>
<div class="mb-1">
<label class="form-label" >Programme Choice 3</label>
<input type="text" readonly class="form-control-plaintext" value="<?php echo $application->get_programme_name($education_details[0]['choice_3']); ?>">
</div>

<div class="mb-1">
<label class="form-label" >Academic Records</label>
<ol>
<?php
$files = glob($unlink_dir.'*.{grudoc}', GLOB_BRACE);

foreach($files as $file) {
$secfile = base64_encode($file);
$ext = str_replace(".","",strrchr($file, '.'));
$title = str_replace('uploads/FOLDER_'.$_SESSION['app_details'][0]['app_id'].'/',"",$file);
echo "<li><a target='_blank' href='app?page=docview&file=$secfile'>".pathinfo($title, PATHINFO_FILENAME)."</a></li>";

?>

<?php
}

?>
</ol>
</div>

<center>
<div class="btn-group btn-group-lg mt-4" role="group" aria-label="Large Horizontal Alternate Primary">
<a href="app?page=address_details" class="btn btn-alt-secondary">
<i class="fa fa-arrow-left"></i> Previous
</a>
</div>
</center>

<?php

}

?>

<?php
}
?>


</div>
</div>

</div><div id="whatsappButton"></div>
</main>

</div>
<script src="assets/js/gru_oas.js"></script>
<script src="assets/js/lib/jquery.min.js"></script>
<script src="assets/loader/waitMe.js"></script>
<script src="assets/js/custom.js"></script>
<script src="assets/js/sweetalert.min.js"></script>
<script src="assets/js/plugins/bootstrap-datepicker/js/bootstrap-datepicker.min.js"></script>
<script src="assets/js/plugins/dropzone/min/dropzone.min.js"></script>
<script src="assets/js/plugins/jquery.maskedinput/jquery.maskedinput.min.js"></script>
<script src="assets/js/plugins/select2/js/select2.full.min.js"></script>
<script src="assets/js/plugins/flatpickr/flatpickr.min.js"></script>
<script src="assets/js/intlTelInput-jquery.min.js"></script>
<script src="whatsapp/venom-button.min.js"></script>
<script>
$('#whatsappButton').venomButton({
phone: '260951653600',
popupMessage: 'Hello, how can we help you?',
message: "I'd like to know more about Gideon Roberty University",
showPopup: true,
position: "right",
linkButton: false,
headerTitle: 'Live Chat Support 24/7',
headerColor: '#25d366',
backgroundColor: '#25d366',
});
</script>
<script>
GRU.helpersOnLoad(['jq-masked-inputs', 'jq-select2']);

$(function () {
$("#phone").intlTelInput({
initialCountry : "ZM",
separateDialCode: !0,
utilsScript: "assets/js/utils.js"
});
})

function cp() {
$("#phone2").val($("#phone").intlTelInput("getNumber"));
}

Dropzone.autoDiscover = false;
jQuery(document).ready(function() {
$("div#meuDropZone").dropzone({
addRemoveLinks: true,
processing: function () {
$('.btn-primary').prop('disabled', true);
},
removedfile: function(file) {
var name = file.name;
$.ajax({
type: 'POST',
url: 'ajax/delete.php',
data: "name="+name,
dataType: 'html'
});
var _ref;
return (_ref = file.previewElement) != null ? _ref.parentNode.removeChild(file.previewElement) : void 0;
},
url: "ajax/upload.php",
parallelUploads: 1,
maxFilesize: <?php echo (int)(ini_get('upload_max_filesize')); ?>,
maxFiles: 20,
init: function () {
var totalFiles = 0,
completeFiles = 0;
this.on("addedfile", function (file) {
totalFiles += 1;
});
this.on("removed file", function (file) {
totalFiles -= 1;
});
this.on("complete", function (file) {
completeFiles += 1;
if (completeFiles === totalFiles) {
$('.btn-primary').prop('disabled', false);
}
});
},
acceptedFiles: ".pdf"
});

});
</script>
<?php $db->kill_conn(); require_once('assets/includes/check_reply.php'); ?>
</body>
</html>
<?php
}else{
http_response_code(403);
}
?>
