<?php
if (isset($is_authorized) && $is_authorized > 0 && !empty($_GET['file'])) {
$src = base64_decode($_GET['file']);
?>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1.0">
<base href="../">
<title><?php echo $env['name']; ?> - Document Viewer</title>
<link rel="shortcut icon" href="assets/img/<?php echo $env['logo']; ?>">
<meta name="author" content="Bwire Mashauri">
<link rel="stylesheet" type="text/css" href="flipbook/min_version/ipages.min.css">
</head>
<body>

<?php

$src = str_replace("../", "", $src);

if ((isset($_SERVER['HTTPS']) &&   (($_SERVER['HTTPS'] == 'on'))) || (isset($_SERVER['HTTPS']) && $_SERVER['SERVER_PORT'] == 443))
{
$actual_link = 'https://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'];
}
else
{
$actual_link = 'http://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'];
}

$actual_link = str_replace("app/index.php","",$actual_link);
$ff = $actual_link.$src;

?>
<div id="flipbook" style="height:100vh;"></div>
<script type="text/javascript" src="flipbook/assets/js/jquery.min.js"></script>
<script type="text/javascript" src="flipbook/min_version/pdf.min.js"></script>
<script type="text/javascript" src="flipbook/min_version/jquery.ipages.min.js"></script>
<script>
$(document).ready(function() {
var options = {
responsive:true,
autoFit:true,
autoHeight: false,

padding:{
top:10,
left:10,
right:10,
bottom:70
},

pdfUrl: '<?php echo $ff; ?>',
pdfAutoCreatePages: true,
pdfBookSizeFromDocument: true,

zoom:1,

toolbarControls: [
{type:'share',        active:false},
{type:'sound',        active:true, optional: true},
{type:'outline',      active:true},
{type:'thumbnails',   active:true},
{type:'gotofirst',    active:true},
{type:'prev',         active:true},
{type:'pagenumber',   active:true},
{type:'next',         active:true},
{type:'gotolast',     active:true},
{type:'zoom-in',      active:true},
{type:'zoom-out',     active:true},
{type:'zoom-default', active:true},
{type:'optional',     active:false},
{type:'download',     active:false, optional: false},
{type:'fullscreen',   active:true, optional: false},
],


};

$('#flipbook').ipages(options);


$('#flipbook').on('ipages:ready', function(e, plugin) {
console.log('event:ready');
});

$('#flipbook').on('ipages:showpage', function(e, plugin, page) {
console.log('event:showpage [' + page + ']');
});

$('#flipbook').on('ipages:hidepage', function(e, plugin, page) {
console.log('event:hidepage [' + page + ']');
});
});
</script>
<?php
}else{
http_response_code(403);
}
?>
