<?php
session_start();
chdir('../../');
require 'classes/database_class.php';
require 'classes/util.php';
require 'classes/application_class.php';

$util = new util;
$application = new application;

if ($_SERVER['REQUEST_METHOD'] === 'POST' && $_POST['csrf_token'] == $_SESSION['csrf_token']) {

$app_id = $util->sanitize($_POST['app_id']);
$red = $util->sanitize($_POST['red']);
$status = $util->sanitize($_POST['status']);

switch ($red) {
case '0':
$red_page = 'all_applications';
break;

case '1':
$red_page = 'pending_applications';
break;

case '2':
$red_page = 'approved_applications';
break;

case '3':
$red_page = 'denied_applications';
break;
}

if ($application->update_status($status, $app_id) === true) {

$util->setMessage("success", "Application status updated successfully");
header("location:../?page=$red_page");

}else{

$util->setMessage("error", "Something went wrong");
header("location:../?page=$red_page");

}


}else{
http_response_code(403);
}
?>
