<?php
session_start();
chdir('../../');
require 'classes/database_class.php';
require 'classes/util.php';
require 'classes/application_class.php';

$util = new util;
$application = new application;

if ($_SERVER['REQUEST_METHOD'] === 'POST' && $_POST['csrf_token'] == $_SESSION['csrf_token']) {

$sname = $util->sanitize(strtoupper($_POST['sname']));
$fname = $util->sanitize(strtoupper($_POST['fname']));
$nrc = !empty($_POST['nrc']) ? $util->sanitize($_POST['nrc']) : NULL;
$passport = !empty($_POST['passport']) ? $util->sanitize($_POST['passport']) : NULL;
$dob = $util->sanitize($_POST['dob']);
$nation = $util->sanitize($_POST['nation']);
$phone = $util->sanitize($_POST['phone']);
$disabled = $util->sanitize($_POST['disabled']);
$nature = !empty($_POST['nature']) ? $util->sanitize($_POST['nature']) : NULL;
$category = $util->sanitize($_POST['category']);
$intake = $util->sanitize($_POST['intake']);
$app_id = $_POST['app_id'];

if ($application->check_nrc($nrc) === true) {

if ($application->check_passport($passport) === true) {

if ($application->update_personal($app_id, $sname, $fname, $nrc, $passport, $dob, $nation,$phone, $disabled, $nature, $category, $intake) === true) {

$util->setMessage("success", "Personal details updated successfully");
header("location:../?page=personal_details");

}else{

$util->setMessage("error", "Something went wrong");
header("location:../?page=personal_details");

}

}else{

$util->setMessage("error", "Passport number is used");
header("location:../?page=personal_details");
}

}else{

$util->setMessage("error", "NRC number is used");
header("location:../?page=personal_details");

}

}else{
http_response_code(403);
}
?>
