<?php
session_start();
chdir('../../');
require 'classes/database_class.php';
require 'classes/util.php';
require 'classes/users_class.php';
require 'classes/session_class.php';
require 'classes/accounts_class.php';


$util = new util;
$users = new users;
$session = new session;
$accounts = new accounts;
$env = $util->env();

if ($_SERVER['REQUEST_METHOD'] === 'POST' && $_POST['csrf_token'] == $_SESSION['csrf_token']) {

$fname = $util->sanitize(ucwords($_POST['fname']));
$lname = $util->sanitize(ucwords($_POST['lname']));
$gender = $util->sanitize($_POST['gender']);
$email = $util->sanitize($_POST['email']);
$status = $util->sanitize($_POST['status']);
$id = $util->sanitize($_POST['id']);

if ($users->valid_email($email, $id) === true) {

if ($users->update_user2($fname, $lname, $gender, $email, $status, $id)) {

$util->setMessage("success", "User updated successfully");
header("location:../?page=system_users");

}else{
$util->setMessage("error", "An error occured");
header("location:../?page=system_users");
}

}else{

$util->setMessage("error", "Email is already registered");
header("location:../?page=system_users");

}

}else{
http_response_code(403);
}
?>
