<?php
session_start();
chdir('../../');
require 'classes/database_class.php';
require 'classes/util.php';
require 'classes/users_class.php';
require 'classes/session_class.php';
require 'classes/accounts_class.php';


$util = new util;
$users = new users;
$session = new session;
$accounts = new accounts;
$env = $util->env();

if ($_SERVER['REQUEST_METHOD'] === 'POST' && $_POST['csrf_token'] == $_SESSION['csrf_token']) {

$current_user = $users->auth_user($_SESSION['logged_account'][0]['email']);

$current_password = $_POST['old_password'];
$new_password = password_hash($_POST['new_password'], PASSWORD_BCRYPT);


if (password_verify($current_password, $current_user[0]['hashed_pw'])) {

$users->update_password($new_password, $current_user[0]['id']);

$util->setMessage("success", "Password updated successfully");

header("location:../?page=account");

}else{

$util->setMessage("error", "Your current password is not correct");

header("location:../?page=account");

}

}else{
http_response_code(403);
}
?>
