<?php
session_start();
chdir('../../');
require 'classes/database_class.php';
require 'classes/util.php';
require 'classes/users_class.php';
require 'classes/session_class.php';
require 'classes/accounts_class.php';
require 'classes/application_class.php';


$util = new util;
$users = new users;
$session = new session;
$accounts = new accounts;
$application = new application;
$env = $util->env();

if ($_SERVER['REQUEST_METHOD'] === 'POST' && $_POST['csrf_token'] == $_SESSION['csrf_token']) {

$email = $util->sanitize($_POST['email']);
$applicant = $application->get_application_by_email($email);

$reference = $_POST['reference'];
$base = 'https://api.lenco.co/access/v2/';
$secret_key = $env['lenco_secret_key'];
$curl = curl_init();
curl_setopt_array($curl, [
CURLOPT_URL => $base."collections/status/$reference",
CURLOPT_RETURNTRANSFER => true,
CURLOPT_ENCODING => "",
CURLOPT_MAXREDIRS => 10,
CURLOPT_TIMEOUT => 30,
CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
CURLOPT_CUSTOMREQUEST => "GET",
CURLOPT_HTTPHEADER => [
"Authorization: Bearer $secret_key",
"accept: application/json",
"content-type: application/json"
],
]);
$response = curl_exec($curl);
$err = curl_error($curl);
curl_close($curl);
if ($err) {
echo "cURL Error #:" . $err;
} else {
$data = json_decode($response, TRUE);

if ($application->save_transaction($applicant[0]['app_id'], $response) === true) {

$util->setMessage("success", "Payment completed successfully");
header("location:../?page=authorize_transaction");

}else{

$util->setMessage("success", "Something went wrong");
header("location:../?page=authorize_transaction");
}

}

}else{
http_response_code(403);
}
?>
