<?php
session_start();
require 'classes/database_class.php';
require 'classes/util.php';

$db = new database;
$util = new util;
$env = $util->env();

require 'classes/application_class.php';
$application = new application;

if (isset($_GET['id'])) {

if (!empty($application->get_personal_details($_GET['id']))) {

$personal_details = $application->get_personal_details($_GET['id']);
$application_fee = $application->get_application_fee($_GET['id']);
$address_details = $application->get_address_details($_GET['id']);
$education_details = $application->get_education_details($_GET['id']);

$sig_file = __DIR__ . '/assets/img/' . $env['signature_file'];
$sig_html = file_exists($sig_file) ? '<img src="' . $sig_file . '" width="100">' : '';

error_reporting(0);
require_once('tcpdf/tcpdf.php');
ini_set('memory_limit','2048M');

class MYPDF extends TCPDF {


public function Header() {
$bMargin = $this->getBreakMargin();
$auto_page_break = $this->AutoPageBreak;
$this->SetAutoPageBreak(false, 0);
$this->SetAlpha(0.15);
$img_file = K_PATH_IMAGES.'../assets/img/gru_report.png';
$this->Image($img_file, 60, 80, 90, 87, '', '', '', false, 300, '', false, false, 0);
$this->SetAlpha(10);
$this->SetAutoPageBreak($auto_page_break, $bMargin);
$this->setPageMark();

$html = '<table width="100%" cellpadding="0" align="center">
<tr><td></td>
</tr>
<tr>
<td>
<img height="90" src="assets/img/gru_report.png">
<h5 style="font-weight:100;"><b style="font-size:13pt; padding-top:30px;">GIDEON ROBERT UNIVERSITY</b><br>
<b style="font-size:11pt;">Pot# 4018 Off Kafue Road, Lilayi, Lusaka, Zambia.</b><br>
<b style="font-size:11pt;">P.O Box</b> 770 Mandahill, Lusaka, Zambia.<br>
<b style="font-size:11pt;">Email:</b> vc@gideonrobertuniversity.com<br>
<b style="font-size:11pt;">Phone:</b> +260 969 899 875 / +260 979 966 615.<br>
</h5>
</td>
</tr>
</table>';

$this->writeHTMLCell(0, 0, '', '', $html, 0, 1, 0, true, '', true);



}


public function Footer() {
$this->SetY(-15);
$this->SetFont("helvetica", 'I', 8);
$this->Cell(0, 10, 'Page '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
}

}

$pdf = new MYPDF('P', PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
$pdf->SetMargins(10, 70, 10, true);

$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor($env['name']);
$pdf->SetTitle('Admission_Card_'.$_GET['id']);
$pdf->SetSubject('Admission_Card_'.$_GET['id']);
$pdf->SetKeywords('Admission_Card_'.$_GET['id']);


$pdf->setPrintHeader(true);
$pdf->setPrintFooter(true);

$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);


$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
	require_once(dirname(__FILE__).'/lang/eng.php');
	$pdf->setLanguageArray($l);
}

$pdf->AddPage('P');

$dis = $personal_details[0]['disability'] == "1" ? "Yes" : "No";
$passport = !empty($personal_details[0]['passport_no']) ? $personal_details[0]['passport_no'] : "Not Applicable";
$nrc = !empty($personal_details[0]['nrc']) ? $personal_details[0]['nrc'] : "Not Applicable";
$nature = !empty($personal_details[0]['nature']) ? $personal_details[0]['nature'] : "Not Applicable";

$html = '<b style="font-size:12px">1. PERSONAL DETAILS</b> <br><br><table width="100%" cellpadding="2" style="font-size:12px">

<tr>

<td width="16%">
<b>SurName :</b>
</td>

<td width="35%">
'.$personal_details[0]['surname'].'
</td>

<td width="17%">
<b>ForeName(s) :</b>
</td>

<td width="36%">
'.$personal_details[0]['fornames'].'
</td>

</tr>

<tr>

<td width="16%">
<b>NRC Number :</b>
</td>

<td width="35%">
'.$nrc.'
</td>

<td width="17%">
<b>Passport Number :</b>
</td>

<td width="36%">
'.$passport.'
</td>

</tr>


<tr>

<td width="16%">
<b>Birthday :</b>
</td>

<td width="35%">
'.date("F d, Y", strtotime($personal_details[0]['dob'])).'
</td>

<td width="17%">
<b>Nationality :</b>
</td>

<td width="36%">
'.$personal_details[0]['nationality'].'
</td>

</tr>

<tr>

<td width="16%">
<b>Gender :</b>
</td>

<td width="35%">
'.$personal_details[0]['gender'].'
</td>

<td width="17%">
<b>Email :</b>
</td>

<td width="36%">
'.$personal_details[0]['email'].'
</td>

</tr>


<tr>

<td width="16%">
<b>Mobile Number :</b>
</td>

<td width="35%">
'.$personal_details[0]['mobile_no'].'
</td>

<td width="17%">
<b>Disability :</b>
</td>

<td width="36%">
'.$dis.'
</td>

</tr>


<tr>

<td colspan="4">
<b>Nature of the disability : </b>'.$nature.'
</td>

</tr>

<tr>

<td colspan="4">
<b>Applying For : </b>'.$personal_details[0]['name'].'
</td>

</tr>

<tr>

<td colspan="4">
<b>Academic Intake : </b>'.$personal_details[0]['intake_name'].'
</td>

</tr>


</table>';

$pdf->writeHTMLCell(0, 0, '', '', $html, 0, 1, 0, true, '', true);

$html = '<b style="font-size:12px"><br>2. ADDRESS DETAILS</b> <br><br><table width="100%" cellpadding="2" style="font-size:12px">

<tr>

<td width="26%">
<b>Residential :</b>
</td>

<td width="25%">
'.$address_details[0]['residential'].'
</td>

<td width="23%">
<b>Postal Address :</b>
</td>

<td width="29%">
'.$address_details[0]['postal_address'].'
</td>

</tr>

<tr>

<td width="26%">
<b>Next of Kin :</b>
</td>

<td width="25%">
'.$address_details[0]['next_of_kin'].'
</td>

<td width="23%">
<b>Next of Kin Relationship :</b>
</td>

<td width="29%">
'.$address_details[0]['nok_relationship'].'
</td>

</tr>


<tr>

<td width="26%">
<b>Next of Kin Phone :</b>
</td>

<td width="25%">
'.$address_details[0]['nok_phone'].'
</td>

<td width="23%">
<b>Next of Kin Residential :</b>
</td>

<td width="25%">
'.$address_details[0]['nok_residential'].'
</td>

</tr>

<tr>

<td width="26%">
<b>Next of Kin Postal Address :</b>
</td>

<td width="25%">
'.$address_details[0]['nok_postal_address'].'
</td>


</tr>




</table>';

$pdf->writeHTMLCell(0, 0, '', '', $html, 0, 1, 0, true, '', true);


$html = '<b style="font-size:12px"><br>3. EDUCATION DETAILS</b> <br><br><table width="100%" cellpadding="2" style="font-size:12px">

<tr>

<td width="26%">
<b>High School :</b>
</td>

<td width="74%">
'.$education_details[0]['hig_school'].'
</td>

</tr>
<tr>

<td width="26%">
<b>Examination Number :</b>
</td>

<td width="74%">
'.$education_details[0]['exam_number'].'
</td>

</tr>
<tr>

<td width="26%">
<b>Completion Year :</b>
</td>

<td width="74%">
'.$education_details[0]['completion_year'].'
</td>

</tr>
<tr>

<td width="26%">
<b>Mode of Study :</b>
</td>

<td width="74%">
'.$education_details[0]['mode_of_study'].'
</td>

</tr>
<tr>

<td width="26%">
<b>Programme Choice 1 :</b>
</td>

<td width="74%">
'.$application->get_programme_name($education_details[0]['choice_1']).'
</td>

</tr>
<tr>

<td width="26%">
<b>Programme Choice 2 :</b>
</td>

<td width="74%">
'.$application->get_programme_name($education_details[0]['choice_2']).'
</td>

</tr>
<tr>

<td width="26%">
<b>Programme Choice 3 :</b>
</td>

<td width="74%">
'.$application->get_programme_name($education_details[0]['choice_3']).'
</td>

</tr>



</table>';

$pdf->writeHTMLCell(0, 0, '', '', $html, 0, 1, 0, true, '', true);

$html = <<<HTML
<style>
body { font-family: helvetica, sans-serif; font-size:12pt; }
.header-table { width:100%; border:none; }
.header-table td { vertical-align: middle; text-align:center; }
.center-title { font-size:14pt; font-weight:bold; }
.center-subtitle { font-size:13pt; }
.university-info { font-size:10pt; line-height:1.3; text-align:center; }
.info { margin-top:10px; line-height:1.5; }
.table { width:100%; border-collapse: collapse; margin-top:15px; }
.table th, .table td { border:1px solid #000; padding:5px; text-align:left; }
.table th { background-color:#ddd; }
.footer { margin-top:20px; text-align:center; font-style:italic; font-size:10pt; }
</style>
<br><div class="footer">
*Forward this admit card to WhatsApp number for official admissions letter to be issued.*
</div>
HTML;


$pdf->writeHTML($html, true, false, true, false, '');

$html = '<br><br><br><table  width="100%" align="center" style="font-size:12px;">
<tr>
<td>'.$sig_html.'</td>
</tr>
<tr>
<td>'.$env['signature_name'].'</td>
</tr>
<tr>
<td><b>'.$env['signature_title'].'</b></td>
</tr>
</table>';

$pdf->writeHTML($html, true, false, true, false, '');

ob_end_clean();

$pdf->Output('Admission_Card_'.$_GET['id'].'.pdf');

}else{
http_response_code(403);
}

}else{
http_response_code(403);
}
?>
