<?php
chdir('../');
require_once 'autoload.php';
$admin = new admin_controller;
$pw_reset_tokens = new reset_pw_tokens_controller;
$mail_config = new smtp_settings_controller;
$uni = new university_controller;

$info = $uni->index();
$smtp = $mail_config->index();

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require 'mail/src/Exception.php';
require 'mail/src/PHPMailer.php';
require 'mail/src/SMTP.php';

date_default_timezone_set($info['timezone']);

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['csrf_token']) && $waf->csrf_validate($_POST['csrf_form_id'], $_POST['csrf_token'], $utility->action_name())) {

$sanitezed_data = $utility->sanitize_request($_POST);

$account_1 = $staff->auth($sanitezed_data['account-email']);
$account_2 = $students->auth($sanitezed_data['account-email']);

$data = $admin->auth($sanitezed_data['login-email']);

if (!empty($data)) {

$reset_token = $utility->createResetToken();

$reset_data['admin_id'] = $data['admin_id'];
$reset_data['token'] = $reset_token['token'];
$reset_data['generated_date'] = date('Y-m-d G:i:s');
$reset_data['expire_date'] = $reset_token['expires'];

if ((isset($_SERVER['HTTPS']) &&   (($_SERVER['HTTPS'] == 'on'))) || (isset($_SERVER['HTTPS']) && $_SERVER['SERVER_PORT'] == 443))
{
$actual_link = 'https://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'];
}
else
{
$actual_link = 'http://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'];
}
$actual_link = str_replace("routes/reset_pw.php","reset_pw?token=".$reset_data['token'],$actual_link);


$msg = '<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1.0" />
<title>Password Reset</title>
</head>
<body style="margin:0; padding:0; background:#f4f4f4; font-family:Arial, sans-serif;">
<table width="100%" cellpadding="0" cellspacing="0" style="background:#f4f4f4; padding:40px 0;">
<tr>
<td align="center">
<table width="480" cellpadding="0" cellspacing="0" style="background:#ffffff; border-radius:8px; overflow:hidden;">
<tr>
<td style="background:#007bff; padding:20px; text-align:center; color:#ffffff; font-size:22px; font-weight:bold;">
Password Reset Request
</td>
</tr>

<tr>
<td style="padding:30px; color:#333333; font-size:16px; line-height:1.6;">
<p>Hello,</p>
<p>You recently requested to reset your password. Click the button below to continue:</p>

<p style="text-align:center; margin:30px 0;">
<a href="'.$actual_link.'"
style="background:#007bff; color:#ffffff; padding:12px 25px; text-decoration:none;
border-radius:5px; font-weight:bold; display:inline-block;">
Reset Password
</a>
</p>

<p>If the button doesn’t work, copy and paste the link below into your browser:</p>

<p style="word-break: break-all;">
'.$actual_link.'
</p>

<p>If you did not request a password reset, please ignore this email.</p>
<p>Thank you,<br><strong>'.$info['name'].'</strong></p>
</td>
</tr>
<tr>
<td style="background:#f8f8f8; padding:15px; text-align:center; color:#888888; font-size:13px;">
© '.date('Y').' '.$info['name'].'. All rights reserved.
</td>
</tr>
</table>
</td>
</tr>
</table>
</body>
</html>
';

$mail = new PHPMailer;
$mail->SMTPOptions = array(
'ssl' => array(
'verify_peer' => false,
'verify_peer_name' => false,
'allow_self_signed' => true
)
);

$mail->isSMTP();
$mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
$mail->Host = $smtp['server'];
$mail->SMTPAuth = true;
$mail->Username = $smtp['username'];
$mail->Password = $smtp['password'];
$mail->SMTPSecure = $smtp['encryption'];
$mail->Port = $smtp['port'];

$mail->setFrom($smtp['username'], $info['name']);
$mail->addAddress($data['email']);
$mail->isHTML(true);

$mail->Subject = 'Reset Password';
$mail->Body    = $msg;
$mail->AltBody = $msg;


if(!$mail->send()) {

$utility->setMessage("warning", "Something went wrong");
header("location:../forgot_pw");

}else{

$pw_reset_tokens->store($reset_data);

$utility->setMessage("info", 'Check your email for more instructions');
header("location:../forgot_pw");

}

}else{

$utility->setMessage("warning", 'Account was not found');

header("location:../forgot_pw");

}
}else{
header("location:../forgot_pw");
}
?>
