<?php
require_once 'autoload.php';

$uni = new university_controller;
$nationality = new nationality_controller;
$courses = new courses_controller;
$payment_gateways = new payment_gateways_controller;

$info = $uni->index();
$gateways = $payment_gateways->index();

if (isset($_SESSION['application'])) {

if (!isset($_SESSION['application']['reference'])) {
$_SESSION['application']['reference'] = $utility->generateReference();
}

foreach ($gateways as $key => $value) {

$details = unserialize($value['details']);

}

?>
<!doctype html>
<html lang="en" class="remember-theme">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1.0">
<title>SERS - Students Examinations Registration System</title>
<meta name="description" content="Students Examinations Registration System">
<meta name="author" content="Bwire Mashauri">
<meta name="robots" content="index, follow">
<link rel="shortcut icon" href="storage/images/misc/<?php echo $info['icon']; ?>">
<link rel="stylesheet" href="assets/js/plugins/bootstrap-datepicker/css/bootstrap-datepicker3.min.css">
<link rel="stylesheet" href="assets/css/intlTelInput.min.css">
<link rel="stylesheet" href="whatsapp/venom-button.min.css" />
<link rel="stylesheet" href="assets/js/plugins/select2/css/select2.min.css">
<link rel="stylesheet" type="text/css" href="dist/css/MultiStep.min.css">
<link rel="stylesheet" type="text/css" href="dist/css/MultiStep-theme.min.css">
<link rel="stylesheet" id="css-main" href="assets/css/main.css">
<?php echo $info['theme'] !== '0' ? '<link type="text/css" rel="stylesheet" id="css-theme" href="assets/css/themes/'.$info['theme'].'.css">' : '' ; ?>
<link href="assets/js/plugins/sweetalert2/sweetalert2.min.css" rel="stylesheet" type="text/css" />
</head>
<body>
<div id="page-loader" class="show"></div>

<div id="page-container">

<main id="main-container">

<div class="bg-image" >

<div class="row g-0 justify-content-center bg-primary-dark-op">
<div class="hero-static col-sm-8 col-md-8 col-l-8 col-xl-8 d-flex align-items-center p-2 px-sm-0">
<div class="block block-transparent block-rounded w-100 mb-0 overflow-hidden">
<div class="block-content block-content-full px-lg-5 px-xl-6 py-4 py-md-5 py-lg-6 bg-body-extra-light">

<div class="text-center">
<img src="storage/images/misc/<?php echo $info['logo']; ?>" height="130" alt="School Logo">
<h5 class="font-size-10 mt-3">Students Examinations Registration System</h5>
<p class="text-muted login_paragraph">Kindly pay the registration fees.</p>
</div>
<div class="block-content block-content-full space-y-3">
<div class="block block-rounded">
  <div class="col-lg-12">
            <div class="block block-rounded block-bordered">

              <div class="block-content">
                <div class="fs-4 mb-1"><?php echo $_SESSION['application']['first_name'].' '.$_SESSION['application']['last_name']; ?></div>
                <address class="fs-sm">
                  <?php echo $_SESSION['application']['reference']; ?><br>
                  <?php echo $_SESSION['application']['email_address']; ?><br>
                  <?php echo $_SESSION['application']['telephone']; ?><br><br>
<table class="table table-bordered table-vcenter table-sm">
<thead>
<tr>
<th >Code</th>
<th>Course Name</th>
<th>Fee</th>
</tr>
</thead>
<tbody>
<?php
$total_cost = 0;

foreach ($_SESSION['application']['courses'] as $key => $value) {

$course = $courses->show($value);
$total_cost = $total_cost + $course['fee'];
?>
<tr>
<td><?php echo $course['code']; ?></td>
<td><?php echo $course['name']; ?></td>
<td><?php echo $info['currency_name'].number_format($course['fee']); ?></td>
</tr>
<?php
}

$_SESSION['application']['total'] = $total_cost;
?>
</tbody>
</table>
<button type="button" id="pay_btn" class="btn btn-primary">Pay <?php echo $info['currency_name'].number_format($total_cost); ?></button>
</address>
</div>
</div>
</div>
</div>
</div>
</div>
</div>
</div>
</div>
</div>
</main>
</div>
<script src="assets/js/main.js"></script>
<script src="assets/js/lib/jquery.min.js"></script>
<script src="assets/js/forms.js"></script>
<script src="assets/js/plugins/jquery-validation/jquery.validate.min.js"></script>
<script src="assets/js/plugins/bootstrap-datepicker/js/bootstrap-datepicker.min.js"></script>
<script src="assets/js/plugins/select2/js/select2.full.min.js"></script>
<script src="assets/js/validation/application.js"></script>
<script src="whatsapp/venom-button.min.js"></script>
<script src="assets/js/plugins/sweetalert2/sweetalert2.min.js"></script>
<script src="assets/js/plugins/jquery.maskedinput/jquery.maskedinput.min.js"></script>
<script type="text/javascript" src="dist/js/MultiStep.min.js"></script>
<script src="https://pay.lenco.co/js/v1/inline.js"></script>

<script>
function initialize_payement() {

LencoPay.getPaid({
key: '<?php echo $details['public_key']; ?>',
reference: '<?php echo $_SESSION['application']['reference']; ?>',
email: '<?php echo $_SESSION['application']['email_address']; ?>',
amount: <?php echo $total_cost; ?>,
currency: '<?php echo $info['code']; ?>',
channels: ["card", "mobile-money"],
customer: {
firstName: "<?php echo $_SESSION['application']['first_name']; ?>",
lastName: "<?php echo $_SESSION['application']['last_name']; ?>",
phone: "<?php echo $_SESSION['application']['telephone']; ?>",
},
onSuccess: function (response) {

const reference = response.reference;
window.location.href = "routes/verify_txn?response=" + response.reference;
},
onClose: function () {

},
onConfirmationPending: function () {

},
});
}

$('#whatsapp_chat').venomButton({
phone: '260977462120',
popupMessage: 'Hello, how can we help you?',
message: "",
showPopup: true,
position: "right",
linkButton: false,
headerTitle: 'Live Chat Support 24/7',
headerColor: '#25d366',
backgroundColor: '#25d366',
});
</script>
<?php require_once('includes/check_reply.php'); ?>
</body>
</html>

<?php
}else{

header("location:./");

}
?>
