<?php
chdir('../');
require_once 'autoload.php';
$exam_enrollments = new exam_enrollments_controller;

$my_dockets = $exam_enrollments->get_dockets($_REQUEST['student_number']);

if (empty($my_dockets)) {
?>
<div class="alert alert-warning">No exam docket was found for student number <strong><?php echo $_REQUEST['student_number']; ?></strong></div>
<div class="mb-2">
<label class="form-label">Student Number</label>
<input type="text" required class="form-control" id="student_number" autocomplete="off" placeholder="Enter your student number">
</div>
<div class="mb-4">
<button type="button" class="btn btn-primary search_btn">Search</button>
<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
</div>
<?php
}else{
?>
<table class="table table-borderless table-striped table-vcenter fs-sm">
<tbody>
<?php
foreach ($my_dockets as $key => $value) {
?>
<tr>
<td class="fw-semibold text-center">
<?php echo $value['name']; ?>
</td>
<td class="d-none d-sm-table-cell">
<?php echo $value['create_date']; ?>
</td>
<td>
<a target="_blank" href="docket?ref=<?php echo $value['reference_no']; ?>">Download</a>
</td>
</tr>
<?php
}
?>
</tbody>
</table>
<?php
}
?>
