<?php
chdir('../');
require_once 'autoload.php';
$admin = new admin_controller;
$programmes = new programmes_controller;
$session = new session;
$uni = new university_controller;
$info = $uni->index();

date_default_timezone_set($info['timezone']);

$page = $utility->get_page();

require_once 'includes/session_validator.php';

if (!empty($is_authenticated) && $is_authenticated == 1) {

$programme_list = $programmes->index();

?>
<!doctype html>
<html lang="en" class="remember-theme">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1.0">
<title>SERS - Exam Enrollments</title>
<meta name="description" content="Students Examinations Registration System">
<meta name="author" content="Bwire Mashauri">
<meta name="robots" content="index, follow">
<base href="../">
<link rel="shortcut icon" href="storage/images/misc/<?php echo $info['icon']; ?>">
<link rel="stylesheet" href="assets/js/plugins/select2/css/select2.min.css">
<link rel="stylesheet" href="assets/js/plugins/datatables-bs5/css/dataTables.bootstrap5.min.css">
<link rel="stylesheet" href="assets/js/plugins/datatables-buttons-bs5/css/buttons.bootstrap5.min.css">
<link rel="stylesheet" href="assets/js/plugins/datatables-responsive-bs5/css/responsive.bootstrap5.min.css">
<link rel="stylesheet" id="css-main" href="assets/css/main.css">
<?php echo $info['theme'] !== '0' ? '<link type="text/css" rel="stylesheet" id="css-theme" href="assets/css/themes/'.$info['theme'].'.css">' : '' ; ?>
<link href="assets/js/plugins/sweetalert2/sweetalert2.min.css" rel="stylesheet" type="text/css" />
</head>
<body>
<div id="page-loader" class="show"></div>

<div id="page-container" class="sidebar-o <?php echo $info['sidebar'];?> enable-page-overlay side-scroll page-header-fixed page-footer-fixed">

<nav id="sidebar" aria-label="Main Navigation">
<div class="bg-header-dark">
<div class="content-header bg-white-5">
<a class="fw-semibold text-white tracking-wide" href="./app/dashboard">
<span class="smini-hidden desc">
Students Examinations Registration System
</span>
</a>
</div>
</div>
<div class="js-sidebar-scroll">
<div class="content-side">

<div class="text-center"><img class="mb-3 center_img" src="storage/images/misc/<?php echo $info['logo']; ?>" height="140" alt="School Logo"></div>

<ul class="nav-main">

<?php require_once 'includes/header.php'; ?>

</ul>
</div>
</div>
</nav>
<header id="page-header">
<div class="content-header">
<div class="space-x-1">
<button type="button" class="btn btn-alt-secondary" data-toggle="layout" data-action="sidebar_toggle">
<i class="fa fa-fw fa-bars"></i>
</button>
</div>
<div class="space-x-1">
<div class="dropdown d-inline-block">
<button type="button" class="btn btn-alt-secondary" id="page-header-user-dropdown" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
<i class="fa fa-fw fa-user d-sm-none"></i>
<span class="d-none d-sm-inline-block"><?php echo $profile['first_name'].' '.$profile['last_name']; ?></span>
<i class="fa fa-fw fa-angle-down opacity-50 ms-1 d-none d-sm-inline-block"></i>
</button>
<div class="dropdown-menu dropdown-menu-end p-0" aria-labelledby="page-header-user-dropdown">
<div class="bg-primary-dark rounded-top fw-semibold text-white text-center p-3">
My Profile
</div>
<div class="p-2">
<a class="dropdown-item" href="app/account">
<i class="far fa-fw fa-user me-1"></i> Account Settings
</a>
<div role="separator" class="dropdown-divider"></div>
<a class="dropdown-item" href="app/logout">
<i class="far fa-fw fa-arrow-alt-circle-left me-1"></i> Log Out
</a>
</div>
</div>
</div>
</div>
</div>
</header>
<main id="main-container">
<div class="content">
<div class="block block-rounded">
<div class="block-header block-header-default">
<h3 class="block-title">
Exam Enrollments
</h3>
</div>
<div class="block-content block-content-full overflow-x-auto">

<table class="table table-bordered table-striped table-vcenter srms_table table-sm app_table">
<thead>
<tr>
<th>Reference</th>
<th>Student Name</th>
<th>NRC</th>
<th>Telephone</th>
<th>Email Address</th>
<th width="100"></th>
</tr>
</thead>
<tbody>
</tbody>
</table>


<div class="modal fade" id="modal-edit" role="dialog" aria-labelledby="modal-add"  data-bs-keyboard="false" data-bs-backdrop="static">
<div class="modal-dialog modal-lg" role="document">
<div class="modal-content">
<div class="block block-rounded shadow-none mb-0">
<div class="block-header block-header-default">
<h4 class="block-title">Examination Enrollment</h4>
</div>
<div class="block-content">
<div id="ajax_response"></div>
</div>
</div>
</div>
</div>
</div>

</div>
</div>
</div>
</main>
<footer id="page-footer" class="bg-body-light">
<div class="content py-0">
<div class="row fs-sm">
<div class="col-sm-6 order-sm-2 mb-1 mb-sm-0 text-center text-sm-end">
<?php echo $info['name']; ?>
</div>
<div class="col-sm-6 order-sm-1 text-center text-sm-start">
<a class="fw-semibold">Students Examinations Registration System</a> &copy; <span data-toggle="year-copy"></span>
</div>
</div>
</div>
</footer>
</div>
<script src="assets/js/main.js"></script>
<script src="assets/js/lib/jquery.min.js"></script>
<script src="assets/js/forms.js"></script>
<script src="assets/js/plugins/datatables/dataTables.min.js"></script>
<script src="assets/js/plugins/select2/js/select2.full.min.js"></script>
<script src="assets/js/plugins/datatables-bs5/js/dataTables.bootstrap5.min.js"></script>
<script src="assets/js/plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="assets/js/plugins/datatables-responsive-bs5/js/responsive.bootstrap5.min.js"></script>
<script src="assets/js/plugins/sweetalert2/sweetalert2.min.js"></script>
<script nonce="<?php echo $wafConfig['nonce']; ?>">
$(".app_table").DataTable({
layout: {
topStart: {
pageLength: {
menu: [10, 15, 20, 50, 100]
}
}
},

ajax: {
url: 'ajax_tables/enrollments_list',
type: "GET"
},

columnDefs: [{className: 'text-center', targets: [5]}],


processing: true,
serverSide: true,
pageLength: 10,
autoWidth: !1,
responsive: !0,
"ordering": false
})


</script>
<?php require_once('includes/check_reply.php'); ?>
</body>
</html>
<?php

}else{

header("location:../");

}
?>
